/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.Tags;
import org.zeith.hammerlib.core.init.TagsHL;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.util.mcf.Resources;

public class OreDictionaryAdapter {
    private static final Map<String, List<ResourceLocation>> MAPPING = new HashMap<String, List<ResourceLocation>>();
    private static final Function<String, List<ResourceLocation>> MAP_GEN = s -> new ArrayList();
    private static boolean hasInit;

    private static void addMapping(String key, ResourceLocation value) {
        MAPPING.computeIfAbsent(key, MAP_GEN).add(value);
    }

    public static void register(String key, String value) {
        OreDictionaryAdapter.register(key, Resources.location((String)(value.contains(":") ? value : "forge:" + value)));
    }

    public static void register(String key, TagKey<Item> tag) {
        if (tag != null) {
            OreDictionaryAdapter.register(key, tag.location());
        }
    }

    public static void register(String key, ResourceLocation value) {
        OreDictionaryAdapter.addMapping(key, value);
    }

    @Nonnull
    public static List<ResourceLocation> get(String od) {
        if (!MAPPING.containsKey(od)) {
            if (od.startsWith("ingot")) {
                OreDictionaryAdapter.addMapping(od, Resources.location("c", "ingots/" + od.substring(5).toLowerCase()));
            }
            if (od.startsWith("ore")) {
                OreDictionaryAdapter.addMapping(od, Resources.location("c", "ores/" + od.substring(3).toLowerCase()));
            }
            if (od.startsWith("gem")) {
                OreDictionaryAdapter.addMapping(od, Resources.location("c", "gems/" + od.substring(3).toLowerCase()));
            }
            if (od.startsWith("block")) {
                OreDictionaryAdapter.addMapping(od, Resources.location("c", "storage_blocks/" + od.substring(5).toLowerCase()));
            }
            if (od.startsWith("dust")) {
                OreDictionaryAdapter.addMapping(od, Resources.location("c", "dusts/" + od.substring(4).toLowerCase()));
            }
            if (od.startsWith("gear")) {
                OreDictionaryAdapter.addMapping(od, Resources.location("c", "gears/" + od.substring(4).toLowerCase()));
            }
            if (od.startsWith("plate")) {
                OreDictionaryAdapter.addMapping(od, Resources.location("c", "plates/" + od.substring(5).toLowerCase()));
            }
            if (MAPPING.containsKey(od)) {
                HLConstants.LOG.debug("Generated mapping for " + od + ": " + String.valueOf(MAPPING.get(od)));
            }
        }
        return MAPPING.computeIfAbsent(od, MAP_GEN);
    }

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionaryAdapter.register("logWood", (TagKey<Item>)ItemTags.LOGS);
            OreDictionaryAdapter.register("plankWood", (TagKey<Item>)ItemTags.PLANKS);
            OreDictionaryAdapter.register("slabWood", (TagKey<Item>)ItemTags.WOODEN_SLABS);
            OreDictionaryAdapter.register("stairWood", (TagKey<Item>)ItemTags.WOODEN_STAIRS);
            OreDictionaryAdapter.register("fenceWood", (TagKey<Item>)Tags.Items.FENCES_WOODEN);
            OreDictionaryAdapter.register("fenceGateWood", (TagKey<Item>)Tags.Items.FENCE_GATES_WOODEN);
            OreDictionaryAdapter.register("doorWood", (TagKey<Item>)ItemTags.WOODEN_DOORS);
            OreDictionaryAdapter.register("stickWood", (TagKey<Item>)Tags.Items.RODS_WOODEN);
            OreDictionaryAdapter.register("treeSapling", (TagKey<Item>)ItemTags.SAPLINGS);
            OreDictionaryAdapter.register("treeLeaves", (TagKey<Item>)ItemTags.LEAVES);
            OreDictionaryAdapter.register("oreGold", (TagKey<Item>)Tags.Items.ORES_GOLD);
            OreDictionaryAdapter.register("oreIron", (TagKey<Item>)Tags.Items.ORES_IRON);
            OreDictionaryAdapter.register("oreLapis", (TagKey<Item>)Tags.Items.ORES_LAPIS);
            OreDictionaryAdapter.register("oreDiamond", (TagKey<Item>)Tags.Items.ORES_DIAMOND);
            OreDictionaryAdapter.register("oreRedstone", (TagKey<Item>)Tags.Items.ORES_REDSTONE);
            OreDictionaryAdapter.register("oreEmerald", (TagKey<Item>)Tags.Items.ORES_EMERALD);
            OreDictionaryAdapter.register("oreQuartz", (TagKey<Item>)Tags.Items.ORES_QUARTZ);
            OreDictionaryAdapter.register("oreCoal", (TagKey<Item>)Tags.Items.ORES_COAL);
            OreDictionaryAdapter.register("ingotIron", (TagKey<Item>)Tags.Items.INGOTS_IRON);
            OreDictionaryAdapter.register("ingotGold", (TagKey<Item>)Tags.Items.INGOTS_GOLD);
            OreDictionaryAdapter.register("nuggetIron", (TagKey<Item>)Tags.Items.NUGGETS_IRON);
            OreDictionaryAdapter.register("nuggetIron", (TagKey<Item>)Tags.Items.NUGGETS_GOLD);
            OreDictionaryAdapter.register("gemDiamond", (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
            OreDictionaryAdapter.register("gemEmerald", (TagKey<Item>)Tags.Items.GEMS_EMERALD);
            OreDictionaryAdapter.register("gemQuartz", (TagKey<Item>)Tags.Items.GEMS_QUARTZ);
            OreDictionaryAdapter.register("gemPrismarine", (TagKey<Item>)Tags.Items.GEMS_PRISMARINE);
            OreDictionaryAdapter.register("gemLapis", (TagKey<Item>)Tags.Items.GEMS_LAPIS);
            OreDictionaryAdapter.register("enderpearl", (TagKey<Item>)Tags.Items.ENDER_PEARLS);
            OreDictionaryAdapter.register("dustRedstone", (TagKey<Item>)Tags.Items.DUSTS_REDSTONE);
            OreDictionaryAdapter.register("dustGlowstone", (TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE);
            OreDictionaryAdapter.register("blockGold", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_GOLD);
            OreDictionaryAdapter.register("blockIron", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON);
            OreDictionaryAdapter.register("blockLapis", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS);
            OreDictionaryAdapter.register("blockDiamond", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
            OreDictionaryAdapter.register("blockRedstone", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE);
            OreDictionaryAdapter.register("blockEmerald", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD);
            OreDictionaryAdapter.register("blockCoal", (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COAL);
            OreDictionaryAdapter.register("blockGlass", (TagKey<Item>)Tags.Items.GLASS_BLOCKS);
            OreDictionaryAdapter.register("dye", (TagKey<Item>)Tags.Items.DYES);
            OreDictionaryAdapter.register("stone", (TagKey<Item>)Tags.Items.STONES);
            OreDictionaryAdapter.register("obsidian", (TagKey<Item>)Tags.Items.OBSIDIANS);
            OreDictionaryAdapter.register("sand", (TagKey<Item>)ItemTags.SAND);
            OreDictionaryAdapter.register("brickStone", (TagKey<Item>)ItemTags.STONE_BRICKS);
            OreDictionaryAdapter.register("chest", (TagKey<Item>)Tags.Items.CHESTS);
            OreDictionaryAdapter.register("chestWood", (TagKey<Item>)Tags.Items.CHESTS_WOODEN);
            OreDictionaryAdapter.register("chestTrapped", (TagKey<Item>)Tags.Items.CHESTS_TRAPPED);
            OreDictionaryAdapter.register("chestEnder", (TagKey<Item>)Tags.Items.CHESTS_ENDER);
            OreDictionaryAdapter.register("piston", TagsHL.Items.PISTONS);
        }
        hasInit = true;
    }

    static {
        OreDictionaryAdapter.initVanillaEntries();
    }
}

