/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.zeith.hammerlib.api.items.CreativeTab;
import org.zeith.hammerlib.api.items.ITabItem;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CreativeTabAdapter {
    private static final List<Tuple2<ItemLike, CreativeTab[]>> REGISTRARS = new ArrayList<Tuple2<ItemLike, CreativeTab[]>>();
    private static final List<CreativeTab> CUSTOM_TABS = new ArrayList<CreativeTab>();
    private static final Map<CreativeModeTab, CreativeTab> REGISTERED = new ConcurrentHashMap<CreativeModeTab, CreativeTab>();
    private static final Supplier<Set<ITabItem>> CUSTOM_TAB_ITEMS = Suppliers.memoize(() -> BuiltInRegistries.ITEM.stream().filter(ITabItem.class::isInstance).map(Cast.convertTo(ITabItem.class)).collect(Collectors.toSet()));
    private static final Function<ItemStack, CreativeModeTab[]> TABS_BY_ITEM = Util.memoize(item -> (CreativeModeTab[])CreativeModeTabs.allTabs().stream().filter(tab -> tab.contains(item)).toArray(CreativeModeTab[]::new));

    public static CreativeModeTab[] getTabs(ItemStack item) {
        return TABS_BY_ITEM.apply(item);
    }

    @SubscribeEvent
    public static void populate(BuildCreativeModeTabContentsEvent e) {
        Set items = ItemStackLinkedSet.createTypeAndComponentsSet();
        CreativeTab tab = REGISTERED.get(e.getTab());
        if (tab != null) {
            for (ItemLike itemLike : tab.contents()) {
                if (itemLike instanceof ITabItem) continue;
                items.add(itemLike.asItem().getDefaultInstance());
            }
        }
        for (ITabItem iTabItem : CUSTOM_TAB_ITEMS.get()) {
            iTabItem.fillItemCategory(e.getTab(), items);
        }
        e.acceptAll((Collection)items);
    }

    public static Map<CreativeModeTab, CreativeTab> getRegistered() {
        return REGISTERED;
    }

    public static List<CreativeTab> getCustomTabs() {
        return CUSTOM_TABS;
    }

    public static <T extends ItemLike> T bindTab(T item, CreativeTab ... tabs) {
        REGISTRARS.add(Tuples.immutable(item, tabs));
        return item;
    }

    public static void deque() {
        while (!REGISTRARS.isEmpty()) {
            Tuple2<ItemLike, CreativeTab[]> tup = REGISTRARS.remove(0);
            for (CreativeTab t : tup.b()) {
                t.add(tup.a());
            }
        }
    }
}

