/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.compat.top;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import mcjty.theoneprobe.api.Color;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.apiimpl.elements.ElementItemStack;
import mcjty.theoneprobe.apiimpl.elements.ElementText;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.compat.top.TOPTooltipConsumer;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.tiles.tooltip.EnumTooltipEngine;
import org.zeith.hammerlib.tiles.tooltip.ITooltipTile;
import org.zeith.hammerlib.util.java.Cast;

public class GetTOP
implements IProbeInfoProvider,
IBlockDisplayOverride,
Function<ITheOneProbe, Void> {
    protected final ResourceLocation id = HLConstants.id("root");

    @Override
    public Void apply(ITheOneProbe top) {
        HammerLib.LOG.info("TheOneProbe API hooked!");
        top.registerProvider((IProbeInfoProvider)this);
        top.registerBlockDisplayOverride((IBlockDisplayOverride)this);
        top.registerElementFactory(GetTOP.create(Panel.ELEMENT_ID, Panel::new));
        return null;
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player player, Level world, BlockState state, IProbeHitData hitData) {
        ITooltipTile tile = Cast.cast(world.getBlockEntity(hitData.getPos()), ITooltipTile.class);
        if (tile != null && tile.isEngineSupported(EnumTooltipEngine.THEONEPROBE)) {
            tile.addTooltip(new TOPTooltipConsumer(info, hitData), player);
        }
    }

    public boolean overrideStandardInfo(ProbeMode mode, IProbeInfo info, Player player, Level world, BlockState state, IProbeHitData hitData) {
        ITooltipTile tile = Cast.cast(world.getBlockEntity(hitData.getPos()), ITooltipTile.class);
        if (tile != null && tile.hasItemIconOverride()) {
            MutableComponent mutableComponent;
            Panel header = new Panel(ILayoutStyleBuilder.spacing(2), Panel.Type.HORIZONTAL);
            header.element((IElement)new ElementItemStack(tile.getItemIconOverride(), new ItemStyle().height(20).width(20)));
            Panel right = new Panel(ILayoutStyleBuilder.create().spacing(3), Panel.Type.VERTICAL);
            if (tile instanceof Nameable) {
                Nameable n = (Nameable)tile;
                mutableComponent = n.getName();
            } else {
                mutableComponent = state.getBlock().getName();
            }
            MutableComponent name = mutableComponent;
            right.element((IElement)new ElementText((Component)name).setLegacy());
            right.element((IElement)new ElementText(CompoundText.create().style(TextStyleClass.MODNAME).text(((ModContainer)ModList.get().getModContainerById(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getNamespace()).get()).getModInfo().getDisplayName()).get()).setLegacy());
            header.element(right);
            info.element((IElement)header);
            return true;
        }
        return false;
    }

    private static IElementFactory create(final ResourceLocation id, final Function<RegistryFriendlyByteBuf, IElement> factory) {
        return new IElementFactory(){

            public IElement createElement(RegistryFriendlyByteBuf buf) {
                return (IElement)factory.apply(buf);
            }

            public ResourceLocation getId() {
                return id;
            }
        };
    }

    public static class Panel
    implements IElement {
        public static final ResourceLocation ELEMENT_ID = HLConstants.id("panel");
        protected List<IElement> children = new ObjectArrayList();
        protected ElementAlignment horizontal;
        protected ElementAlignment vertical;
        protected ILayoutStyle layout;
        protected Integer borderColor;
        protected int spacing;

        public Panel(Type type) {
            this(ILayoutStyleBuilder.create(), type);
        }

        public Panel(ILayoutStyle layout, Type type) {
            this(layout, type == Type.VERTICAL);
        }

        public Panel(boolean vertical) {
            this(ILayoutStyleBuilder.create(), vertical);
        }

        public Panel(ILayoutStyle layout, boolean vertical) {
            if (vertical) {
                this.vertical = layout.getAlignment();
            } else {
                this.horizontal = layout.getAlignment();
            }
            this.layout = layout;
            this.borderColor = layout.getBorderColor();
            this.spacing = layout.getSpacing();
        }

        public Panel(RegistryFriendlyByteBuf buffer) {
            if (buffer.readBoolean()) {
                this.vertical = (ElementAlignment)buffer.readEnum(ElementAlignment.class);
            } else {
                this.horizontal = (ElementAlignment)buffer.readEnum(ElementAlignment.class);
            }
            if (buffer.readBoolean()) {
                this.borderColor = buffer.readInt();
            }
            this.spacing = buffer.readInt();
            this.layout = ILayoutStyleBuilder.create().topPadding(buffer.readInt()).bottomPadding(buffer.readInt()).leftPadding(buffer.readInt()).rightPadding(buffer.readInt());
            this.children.addAll(ProbeInfo.createElements((RegistryFriendlyByteBuf)buffer));
        }

        public void toBytes(RegistryFriendlyByteBuf buffer) {
            buffer.writeBoolean(this.vertical != null);
            buffer.writeEnum((Enum)(this.vertical != null ? this.vertical : this.horizontal));
            buffer.writeBoolean(this.borderColor != null);
            if (this.borderColor != null) {
                buffer.writeInt(this.borderColor.intValue());
            }
            buffer.writeInt(this.spacing).writeInt(this.layout.getTopPadding()).writeInt(this.layout.getBottomPadding()).writeInt(this.layout.getLeftPadding()).writeInt(this.layout.getRightPadding());
            ProbeInfo.writeElements(this.children, (RegistryFriendlyByteBuf)buffer);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(GuiGraphics matrix, int x, int y) {
            int totWidth;
            if (this.borderColor != null) {
                totWidth = this.getWidth();
                int h = this.getHeight();
                RenderHelper.drawHorizontalLine((GuiGraphics)matrix, (int)x, (int)y, (int)(x + totWidth - 1), (int)this.borderColor);
                RenderHelper.drawHorizontalLine((GuiGraphics)matrix, (int)x, (int)(y + h - 1), (int)(x + totWidth - 1), (int)this.borderColor);
                RenderHelper.drawVerticalLine((GuiGraphics)matrix, (int)x, (int)y, (int)(y + h - 1), (int)this.borderColor);
                RenderHelper.drawVerticalLine((GuiGraphics)matrix, (int)(x + totWidth - 1), (int)y, (int)(y + h), (int)this.borderColor);
                x += 3;
                y += 3;
            }
            if (this.horizontal != null) {
                x += this.layout.getLeftPadding();
                totWidth = this.getHeight() - this.getYPadding();
                for (IElement child : this.children) {
                    int w = child.getHeight();
                    int cx = y;
                    switch (this.horizontal) {
                        default: {
                            break;
                        }
                        case ALIGN_CENTER: {
                            cx = y + (totWidth - w) / 2;
                            break;
                        }
                        case ALIGN_BOTTOMRIGHT: {
                            cx = y + totWidth - w;
                        }
                    }
                    child.render(matrix, x, cx + this.layout.getTopPadding());
                    x += child.getWidth() + this.spacing;
                }
                return;
            }
            if (this.vertical != null) {
                y += this.layout.getTopPadding();
                totWidth = this.getWidth() - this.getXPadding();
                for (IElement child : this.children) {
                    int w = child.getWidth();
                    int cx = x;
                    switch (this.vertical) {
                        default: {
                            break;
                        }
                        case ALIGN_CENTER: {
                            cx = x + (totWidth - w) / 2;
                            break;
                        }
                        case ALIGN_BOTTOMRIGHT: {
                            cx = x + totWidth - w;
                        }
                    }
                    child.render(matrix, cx + this.layout.getLeftPadding(), y);
                    y += child.getHeight() + this.spacing;
                }
            }
        }

        public int getHeight() {
            int h = 0;
            if (this.vertical != null) {
                for (IElement child : this.children) {
                    h += child.getHeight();
                }
                return h + this.spacing * (this.children.size() - 1) + this.getBorderSpacing() + this.getYPadding();
            }
            for (IElement child : this.children) {
                h = Math.max(child.getHeight(), h);
            }
            return h + this.getBorderSpacing() + this.getYPadding();
        }

        public int getWidth() {
            int w = 0;
            if (this.horizontal != null) {
                for (IElement child : this.children) {
                    w += child.getWidth();
                }
                return w + this.spacing * (this.children.size() - 1) + this.getBorderSpacing() + this.getXPadding();
            }
            for (IElement child : this.children) {
                w = Math.max(child.getWidth(), w);
            }
            return w + this.getBorderSpacing() + this.getXPadding();
        }

        protected int getYPadding() {
            return this.layout.getBottomPadding() + this.layout.getTopPadding();
        }

        protected int getXPadding() {
            return this.layout.getLeftPadding() + this.layout.getRightPadding();
        }

        protected int getBorderSpacing() {
            return this.borderColor == null ? 0 : 6;
        }

        public ResourceLocation getID() {
            return ELEMENT_ID;
        }

        public List<IElement> getElements() {
            return this.getChildren();
        }

        public Panel element(IElement element) {
            this.children.add(element);
            return this;
        }

        @Generated
        public List<IElement> getChildren() {
            return this.children;
        }

        @Generated
        public ILayoutStyle getLayout() {
            return this.layout;
        }

        public static enum Type {
            VERTICAL,
            HORIZONTAL;

        }
    }

    public static interface ILayoutStyleBuilder {
        public static ILayoutStyle create() {
            return new LayoutStyle();
        }

        public static ILayoutStyle border(Color color) {
            return new LayoutStyle().borderColor(color);
        }

        public static ILayoutStyle border(Integer color) {
            return new LayoutStyle().borderColor(color);
        }

        public static ILayoutStyle spacing(int spacing) {
            return new LayoutStyle().spacing(spacing);
        }

        public static ILayoutStyle aligned(ElementAlignment align) {
            return new LayoutStyle().alignment(align);
        }

        public static ILayoutStyle padding(int padding) {
            return new LayoutStyle().padding(padding);
        }

        public static ILayoutStyle padding(int xPadding, int yPadding) {
            return new LayoutStyle().hPadding(xPadding).vPadding(yPadding);
        }

        public static ILayoutStyle padding(int top, int bottom, int left, int right) {
            return new LayoutStyle().topPadding(top).bottomPadding(bottom).leftPadding(left).rightPadding(right);
        }
    }
}

