/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.zeith.hammerlib.util.colors.ColorHelper;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.itf.IntToIntFunction;

public class RenderUtils {
    public static float zLevel = 0.0f;
    private static final Random rand = new Random();
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public static TextureAtlasSprite getMainSprite(ResourceLocation tex) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(tex);
    }

    public static void renderItemIntoGui(PoseStack pose, ItemStack stack, int x, int y) {
        RenderUtils.renderItemIntoGui(pose, stack, (float)x, (float)y);
    }

    public static void renderItemIntoGui(PoseStack pose, ItemStack stack, float x, float y) {
        boolean flag;
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer ir = mc.getItemRenderer();
        TextureManager tm = mc.getTextureManager();
        BakedModel p_115131_ = ir.getModel(stack, null, null, 0);
        tm.getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.pushMatrix();
        posestack.mul((Matrix4fc)pose.last().pose());
        posestack.translate(x, y, 100.0f);
        posestack.translate(8.0f, 8.0f, 0.0f);
        posestack.scale(1.0f, -1.0f, 1.0f);
        posestack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = flag = !p_115131_.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
        }
        ir.render(stack, ItemDisplayContext.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.NO_OVERLAY, p_115131_);
        multibuffersource$buffersource.endBatch();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        posestack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawTexturedModalRect(GuiGraphics pose, float x, float y, float texX, float texY, float width, float height) {
        RenderUtils.drawTexturedModalRect(pose.pose(), x, y, texX, texY, width, height);
    }

    public static void drawTexturedModalRect(PoseStack pose, float x, float y, float texX, float texY, float width, float height) {
        Matrix4f pose4f = pose.last().pose();
        float n = 0.00390625f;
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder vb = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        vb.addVertex(pose4f, x, y + height, zLevel).setUv(texX * n, (texY + height) * n);
        vb.addVertex(pose4f, x + width, y + height, zLevel).setUv((texX + width) * n, (texY + height) * n);
        vb.addVertex(pose4f, x + width, y, zLevel).setUv((texX + width) * n, texY * n);
        vb.addVertex(pose4f, x, y, zLevel).setUv(texX * n, texY * n);
        BufferUploader.drawWithShader((MeshData)vb.buildOrThrow());
    }

    public static void drawFullTexturedModalRect(GuiGraphics pose, float x, float y, float width, float height) {
        Matrix4f pose4f = pose.pose().last().pose();
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder vb = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        vb.addVertex(pose4f, x, y + height, zLevel).setUv(0.0f, 1.0f);
        vb.addVertex(pose4f, x + width, y + height, zLevel).setUv(1.0f, 1.0f);
        vb.addVertex(pose4f, x + width, y, zLevel).setUv(1.0f, 0.0f);
        vb.addVertex(pose4f, x, y, zLevel).setUv(0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)vb.buildOrThrow());
    }

    public static void drawColoredModalRect(GuiGraphics pose, float x, float y, float width, float height, int rgb) {
        Matrix4f pose4f = pose.pose().last().pose();
        float r = ColorHelper.getRed(rgb);
        float g = ColorHelper.getGreen(rgb);
        float b = ColorHelper.getBlue(rgb);
        float a = ColorHelper.getAlpha(rgb);
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder vb = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        vb.addVertex(pose4f, x, y + height, zLevel).setColor(r, g, b, a);
        vb.addVertex(pose4f, x + width, y + height, zLevel).setColor(r, g, b, a);
        vb.addVertex(pose4f, x + width, y, zLevel).setColor(r, g, b, a);
        vb.addVertex(pose4f, x, y, zLevel).setColor(r, g, b, a);
        BufferUploader.drawWithShader((MeshData)vb.buildOrThrow());
    }

    public static void drawTexturedModalRect(PoseStack pose, float xCoord, float yCoord, @Nullable TextureAtlasSprite textureSprite, float widthIn, float heightIn) {
        float maxV;
        float maxU;
        float minV;
        float minU;
        Matrix4f pose4f = pose.last().pose();
        if (textureSprite == null) {
            minU = 0.0f;
            minV = 0.0f;
            maxU = 1.0f;
            maxV = 1.0f;
        } else {
            minU = textureSprite.getU0();
            minV = textureSprite.getV0();
            maxU = textureSprite.getU1();
            maxV = textureSprite.getV1();
        }
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder vb = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        vb.addVertex(pose4f, xCoord, yCoord + heightIn, 0.0f).setUv(minU, maxV);
        vb.addVertex(pose4f, xCoord + widthIn, yCoord + heightIn, 0.0f).setUv(maxU, maxV);
        vb.addVertex(pose4f, xCoord + widthIn, yCoord, 0.0f).setUv(maxU, minV);
        vb.addVertex(pose4f, xCoord, yCoord, 0.0f).setUv(minU, minV);
        BufferUploader.drawWithShader((MeshData)vb.buildOrThrow());
    }

    public static void drawTextRGBA(Font font, GuiGraphics stack, String s, int x, int y, int r, int g, int b, int a) {
        stack.drawString(font, s, x, y, ColorHelper.packARGB(r, g, b, a));
    }

    public static void drawTextRGBA(Font font, GuiGraphics stack, Component s, int x, int y, int r, int g, int b, int a) {
        stack.drawString(font, s, x, y, ColorHelper.packARGB(r, g, b, a));
    }

    public static void renderColorfulLightRayEffects(MultiBufferSource buffers, PoseStack matrix, IntToIntFunction rgba, long seed, float progress, int dstJump, int rayCount) {
        RenderUtils.renderColorfulLightRayEffects(buffers, matrix, rgba, seed, progress, dstJump, 1.0f, rayCount);
    }

    public static void renderLightRayEffects(MultiBufferSource buffers, PoseStack matrix, int rgba, long seed, float progress, int dstJump, int rayCount) {
        RenderUtils.renderLightRayEffects(buffers, matrix, rgba, seed, progress, dstJump, 1.0f, rayCount);
    }

    public static void setGlClearColorFromInt(int colorValue, int opacity) {
        int i = (colorValue & 0xFF0000) >> 16;
        int j = (colorValue & 0xFF00) >> 8;
        int k = colorValue & 0xFF;
        RenderSystem.clearColor((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)opacity / 255.0f));
    }

    public static void renderLightRayEffects(MultiBufferSource buffers, PoseStack matrix, int rgba, long seed, float progress, int dstJump, float scale, int rayCount) {
        rand.setSeed(seed);
        float dstJumpScale = 30.0f / (Math.min((float)dstJump, 10.0f * scale) / 10.0f);
        float f7 = Math.min(progress > 0.8f ? (progress - 0.8f) / 0.2f : 0.0f, 1.0f);
        int r = rgba >> 16 & 0xFF;
        int g = rgba >> 8 & 0xFF;
        int b = rgba & 0xFF;
        int a = rgba >> 24 & 0xFF;
        VertexConsumer VertexConsumer2 = buffers.getBuffer(RenderType.lightning());
        matrix.pushPose();
        for (int i = 0; i < rayCount; ++i) {
            matrix.mulPose(Axis.XP.rotationDegrees(rand.nextFloat() * 360.0f));
            matrix.mulPose(Axis.YP.rotationDegrees(rand.nextFloat() * 360.0f));
            matrix.mulPose(Axis.ZP.rotationDegrees(rand.nextFloat() * 360.0f));
            matrix.mulPose(Axis.XP.rotationDegrees(rand.nextFloat() * 360.0f));
            matrix.mulPose(Axis.YP.rotationDegrees(rand.nextFloat() * 360.0f));
            matrix.mulPose(Axis.ZP.rotationDegrees(rand.nextFloat() * 360.0f + progress * 360.0f));
            float f3 = rand.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = rand.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f mat = matrix.last().pose();
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex2(VertexConsumer2, mat, f3 /= dstJumpScale, f4 /= dstJumpScale, r, g, b);
            RenderUtils.vertex3(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex3(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex4(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex4(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex2(VertexConsumer2, mat, f3, f4, r, g, b);
        }
        matrix.popPose();
    }

    public static void renderColorfulLightRayEffects(MultiBufferSource buffers, PoseStack matrix, IntToIntFunction rgba, long seed, float progress, int dstJump, float scale, int rayCount) {
        rand.setSeed(seed);
        float dstJumpScale = 30.0f / (Math.min((float)dstJump, 10.0f * scale) / 10.0f);
        float f7 = Math.min(progress > 0.8f ? (progress - 0.8f) / 0.2f : 0.0f, 1.0f);
        VertexConsumer VertexConsumer2 = buffers.getBuffer(RenderType.lightning());
        matrix.pushPose();
        for (int i = 0; i < rayCount; ++i) {
            int irgba = rgba.applyAsInt(i);
            int r = irgba >> 16 & 0xFF;
            int g = irgba >> 8 & 0xFF;
            int b = irgba & 0xFF;
            int a = irgba >> 24 & 0xFF;
            matrix.mulPose(Axis.XP.rotationDegrees(rand.nextFloat() * 360.0f));
            matrix.mulPose(Axis.YP.rotationDegrees(rand.nextFloat() * 360.0f));
            matrix.mulPose(Axis.ZP.rotationDegrees(rand.nextFloat() * 360.0f));
            matrix.mulPose(Axis.XP.rotationDegrees(rand.nextFloat() * 360.0f));
            matrix.mulPose(Axis.YP.rotationDegrees(rand.nextFloat() * 360.0f));
            matrix.mulPose(Axis.ZP.rotationDegrees(rand.nextFloat() * 360.0f + progress * 360.0f));
            float f3 = rand.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = rand.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f mat = matrix.last().pose();
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex2(VertexConsumer2, mat, f3 /= dstJumpScale, f4 /= dstJumpScale, r, g, b);
            RenderUtils.vertex3(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex3(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex4(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(VertexConsumer2, mat, r, g, b, a);
            RenderUtils.vertex4(VertexConsumer2, mat, f3, f4, r, g, b);
            RenderUtils.vertex2(VertexConsumer2, mat, f3, f4, r, g, b);
        }
        matrix.popPose();
    }

    private static void vertex01(VertexConsumer c, Matrix4f pose, int r, int g, int b, int a) {
        c.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        c.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a);
    }

    private static void vertex2(VertexConsumer c, Matrix4f pose, float p_229060_2_, float p_229060_3_, int r, int g, int b) {
        c.addVertex(pose, -HALF_SQRT_3 * p_229060_3_, p_229060_2_, -0.5f * p_229060_3_).setColor(r, g, b, 0);
    }

    private static void vertex3(VertexConsumer c, Matrix4f pose, float p_229062_2_, float p_229062_3_, int r, int g, int b) {
        c.addVertex(pose, HALF_SQRT_3 * p_229062_3_, p_229062_2_, -0.5f * p_229062_3_).setColor(r, g, b, 0);
    }

    private static void vertex4(VertexConsumer c, Matrix4f pose, float p_229063_2_, float p_229063_3_, int r, int g, int b) {
        c.addVertex(pose, 0.0f, p_229063_2_, p_229063_3_).setColor(r, g, b, 0);
    }

    public static void drawRect(GuiGraphics pose, int x, int y, int width, int height, int color) {
        ShaderInstance sdr = RenderSystem.getShader();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderUtils.drawColoredModalRect(pose, x, y, width, height, color);
        RenderSystem.setShader(Cast.constant(sdr));
    }

    public static class PlayerRenderUtil {
        public static void rotateIfSneaking(PoseStack pose, Player player) {
            if (player.isShiftKeyDown()) {
                PlayerRenderUtil.applySneakingRotation(pose);
            }
        }

        public static void applySneakingRotation(PoseStack pose) {
            pose.translate(0.0f, 0.2f, 0.0f);
            pose.mulPose(Axis.XP.rotationDegrees(90.0f));
        }

        public static void translateToHeadLevel(PoseStack pose, Player player) {
            pose.translate(0.0f, -player.getEyeHeight(), 0.0f);
            if (player.isShiftKeyDown()) {
                pose.translate(0.25f * Mth.sin((float)(player.getYRot() * (float)Math.PI / 180.0f)), 0.25f * Mth.cos((float)(player.getYRot() * (float)Math.PI / 180.0f)), 0.0f);
            }
        }

        public static void translateToFace(PoseStack pose) {
            pose.mulPose(Axis.YP.rotationDegrees(90.0f));
            pose.mulPose(Axis.XP.rotationDegrees(180.0f));
            pose.translate(0.0f, -4.35f, -1.27f);
        }

        public static void defaultTransforms(PoseStack pose) {
            pose.translate(0.0f, 3.0f, 1.0f);
            pose.scale(0.55f, 0.55f, 0.55f);
        }

        public static void translateToChest(PoseStack pose) {
            pose.mulPose(Axis.XP.rotationDegrees(180.0f));
            pose.translate(0.0f, -3.2f, -0.85f);
        }
    }
}

