/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammerlib.client.texture.HttpTextureDownloader;
import org.zeith.hammerlib.util.java.Hashers;
import org.zeith.hammerlib.util.mcf.Resources;

public class FXUtils {
    public static final ResourceLocation EMPTY_TEXTURE = Resources.location("hammerlib", "textures/empty.png");
    private static final Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();

    public static ResourceLocation urlToTexturePath(String url) {
        String withoutHTTP = url.substring(url.indexOf("://") + 3);
        String protocol = url.substring(0, url.indexOf("://"));
        return Resources.location("hammerlib", protocol + "/" + Hashers.SHA1.hashify(withoutHTTP));
    }

    public static AbstractTexture downloadTexture(ResourceLocation texture, String url) {
        return HttpTextureDownloader.create(texture, url);
    }

    public static void bindTextureURL(String url) {
        FXUtils.downloadTexture(FXUtils.urlToTexturePath(url), url).bind();
    }

    public static void bindTexture(String f) {
        if (f.startsWith("http")) {
            FXUtils.bindTextureURL(f);
        } else {
            if (textures.containsKey(f)) {
                FXUtils.bindTexture(textures.get(f));
                return;
            }
            ResourceLocation value = Resources.location(f);
            textures.put(f, value);
            FXUtils.bindTexture(value);
        }
    }

    public static void bindTexture(ResourceLocation path) {
        FXUtils.bindTextureCurShader(path);
        FXUtils.setPositionTexShader();
    }

    public static void bindTextureCurShader(ResourceLocation path) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)path);
    }

    public static void setPositionTexShader() {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
    }

    public static void setPositionTexColorShader() {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
    }

    public static void setColor(float red, float green, float blue, float alpha) {
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void bindTexture(String namespace, String path) {
        String f = namespace + ":" + path;
        if (textures.containsKey(f)) {
            FXUtils.bindTexture(textures.get(f));
            return;
        }
        ResourceLocation value = Resources.location(namespace, path);
        textures.put(f, value);
        FXUtils.bindTexture(value);
    }
}

