/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface IBESR<T extends BlockEntity> {
    public void render(T var1, float var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);

    default public boolean shouldRenderOffScreen(T tile) {
        return false;
    }

    default public int getViewDistance() {
        return 64;
    }

    default public AABB getRenderBoundingBox(T blockEntity) {
        return new AABB(blockEntity.getBlockPos());
    }

    default public boolean shouldRender(T entity, Vec3 camera) {
        return Vec3.atCenterOf((Vec3i)entity.getBlockPos()).closerThan((Position)camera, (double)this.getViewDistance());
    }

    public static interface Infinite<T extends BlockEntity>
    extends IBESR<T> {
        @Override
        default public AABB getRenderBoundingBox(T blockEntity) {
            return AABB.INFINITE;
        }

        @Override
        default public int getViewDistance() {
            return Integer.MAX_VALUE;
        }

        @Override
        default public boolean shouldRenderOffScreen(T tile) {
            return true;
        }
    }
}

