/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.tiles;

import net.minecraft.world.level.block.entity.BlockEntity;
import org.zeith.hammerlib.event.listeners.ServerListener;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.SyncTileEntityPacket;

public interface ISyncableTile {
    default public void sync() {
        BlockEntity tile;
        ISyncableTile iSyncableTile = this;
        if (iSyncableTile instanceof BlockEntity && (tile = (BlockEntity)iSyncableTile).hasLevel() && !tile.getLevel().isClientSide) {
            ServerListener.syncTileEntity(tile);
        }
    }

    default public void syncNow() {
        this.syncUpdateTagHLPipeline();
    }

    default public void syncWithHLPipeline() {
        ISyncableTile iSyncableTile = this;
        if (iSyncableTile instanceof BlockEntity) {
            BlockEntity tile = (BlockEntity)iSyncableTile;
            Network.sendToTracking(tile, (IPacket)new SyncTileEntityPacket(tile, false));
        }
    }

    default public void syncUpdateTagHLPipeline() {
        ISyncableTile iSyncableTile = this;
        if (iSyncableTile instanceof BlockEntity) {
            BlockEntity tile = (BlockEntity)iSyncableTile;
            Network.sendToTracking(tile, (IPacket)new SyncTileEntityPacket(tile, true));
        }
    }
}

