/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.registrars;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.fluid.FluidTypeHL;
import org.zeith.hammerlib.api.fml.ICustomRegistrar;
import org.zeith.hammerlib.api.fml.IRegisterListener;
import org.zeith.hammerlib.api.items.CreativeTab;
import org.zeith.hammerlib.api.proxy.IProxy;
import org.zeith.hammerlib.core.adapter.TagAdapter;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.Resources;
import org.zeith.hammerlib.util.mcf.fluid.FluidIngredient;
import org.zeith.hammerlib.util.mcf.fluid.FluidIngredientStack;

public class FluidFactory
implements ICustomRegistrar,
ItemLike {
    public final FluidType type;
    public final Supplier<Item> bucket;
    public final BaseFlowingFluid.Properties fluidProps;
    public final Supplier<BaseFlowingFluid.Source> source;
    public final Supplier<BaseFlowingFluid.Flowing> flowing;
    public final Supplier<LiquidBlock> block;
    protected Supplier<Supplier<RenderType>> renderType = () -> RenderType::solid;
    protected final List<TagKey<Fluid>> fluidTags = Lists.newArrayList();
    protected final List<CreativeTab> tabs = Lists.newArrayList();

    public FluidFactory(Supplier<FluidType> typeGenerator, Function<Supplier<FlowingFluid>, Item> bucket, UnaryOperator<BaseFlowingFluid.Properties> propertyModifier, Function<Supplier<? extends FlowingFluid>, LiquidBlock> block, Function<BaseFlowingFluid.Properties, BaseFlowingFluid.Source> sourceGen, Function<BaseFlowingFluid.Properties, BaseFlowingFluid.Flowing> flowingGen) {
        this.type = typeGenerator.get();
        this.block = block != null ? Suppliers.memoize(() -> (LiquidBlock)block.apply(this::getFlowing)) : null;
        this.bucket = bucket != null ? Suppliers.memoize(() -> {
            Item item = (Item)bucket.apply(this::getSource);
            for (CreativeTab tab : this.tabs) {
                tab.add(item);
            }
            return item;
        }) : null;
        BaseFlowingFluid.Properties fp = new BaseFlowingFluid.Properties(this::getType, this::getSource, this::getFlowing);
        if (this.block != null) {
            fp = fp.block(this::getBlock);
        }
        if (this.bucket != null) {
            fp = fp.bucket(this::getBucket);
        }
        this.fluidProps = propertyModifier != null ? (BaseFlowingFluid.Properties)propertyModifier.apply(fp) : fp;
        this.source = Suppliers.memoize(() -> (BaseFlowingFluid.Source)sourceGen.apply(this.fluidProps));
        this.flowing = Suppliers.memoize(() -> (BaseFlowingFluid.Flowing)flowingGen.apply(this.fluidProps));
    }

    protected FluidFactory addFluidTags(Collection<TagKey<Fluid>> fluidTags) {
        this.fluidTags.addAll(fluidTags);
        return this;
    }

    protected FluidFactory withRenderType(Supplier<Supplier<RenderType>> renderType) {
        this.renderType = renderType;
        return this;
    }

    protected FluidFactory addToTabs(Collection<CreativeTab> tab) {
        this.tabs.addAll(tab);
        return this;
    }

    public FluidStack stack(int amount) {
        return new FluidStack((Fluid)this.source.get(), amount);
    }

    public FluidIngredient ingredient() {
        return FluidIngredient.ofFluids(List.of(new FluidStack((Fluid)this.source.get(), 1)));
    }

    public FluidIngredientStack ingredient(int amount) {
        return new FluidIngredientStack(this.ingredient(), amount);
    }

    public FluidType getType() {
        return this.type;
    }

    public BaseFlowingFluid.Source getSource() {
        return this.source.get();
    }

    public BlockState getSourceBlockState() {
        return this.source.get().getSource(false).createLegacyBlock();
    }

    public BaseFlowingFluid.Flowing getFlowing() {
        return this.flowing.get();
    }

    @Nullable
    public Item getBucket() {
        return this.bucket != null ? this.bucket.get() : null;
    }

    @Nullable
    public LiquidBlock getBlock() {
        return this.block != null ? this.block.get() : null;
    }

    public ResourceLocation subId(ResourceLocation fluidId, String thing) {
        return Resources.location(fluidId.getNamespace(), fluidId.getPath() + "_" + thing);
    }

    public boolean is(Fluid fluid) {
        return fluid == this.source || fluid == this.flowing;
    }

    public boolean is(FluidType fluid) {
        return fluid == this.type;
    }

    public boolean is(FluidStack fluid) {
        return fluid != null && !fluid.isEmpty() && this.is(fluid.getFluid());
    }

    public boolean is(Block fluid) {
        return fluid == this.getBlock();
    }

    public boolean is(Item bucket) {
        return bucket == this.getBucket();
    }

    public boolean has(ItemStack stack) {
        return !stack.isEmpty() && FluidUtil.getFluidHandler((ItemStack)stack).map(h -> {
            int t = h.getTanks();
            for (int i = 0; i < t; ++i) {
                FluidStack ft = h.getFluidInTank(i);
                if (!this.is(ft)) continue;
                return true;
            }
            return false;
        }).orElse(false) != false;
    }

    public boolean has(ItemStack stack, int minAmount) {
        return !stack.isEmpty() && FluidUtil.getFluidHandler((ItemStack)stack).map(h -> {
            int amt = 0;
            int t = h.getTanks();
            for (int i = 0; i < t; ++i) {
                FluidStack ft = h.getFluidInTank(i);
                if (!this.is(ft) || (amt += ft.getAmount()) < minAmount) continue;
                return true;
            }
            return amt >= minAmount;
        }).orElse(false) != false;
    }

    @Override
    public void performRegister(RegisterEvent e, ResourceLocation fluidId) {
        IRegisterListener rl;
        FluidType fluidType;
        ResourceKey key = e.getRegistryKey();
        if (NeoForgeRegistries.Keys.FLUID_TYPES.equals(key)) {
            fluidType = this.type;
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPreRegistered(fluidId);
            }
            e.register(NeoForgeRegistries.Keys.FLUID_TYPES, fluidId, Cast.constant(this.type));
            fluidType = this.type;
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPostRegistered(fluidId);
            }
        }
        if (Registries.FLUID.equals(key)) {
            fluidType = this.getSource();
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPreRegistered(fluidId);
            }
            if ((fluidType = this.getFlowing()) instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPreRegistered(this.subId(fluidId, "flow"));
            }
            e.register(Registries.FLUID, fluidId, this.source::get);
            e.register(Registries.FLUID, this.subId(fluidId, "flow"), this.flowing::get);
            fluidType = this.getSource();
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPostRegistered(fluidId);
            }
            if ((fluidType = this.getFlowing()) instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPostRegistered(this.subId(fluidId, "flow"));
            }
            Runnable bind = (Runnable)IProxy.createSided(() -> () -> () -> {
                ItemBlockRenderTypes.setRenderLayer((Fluid)this.getSource(), (RenderType)((RenderType)Cast.get2(this.renderType)));
                ItemBlockRenderTypes.setRenderLayer((Fluid)this.getFlowing(), (RenderType)((RenderType)Cast.get2(this.renderType)));
            }, () -> () -> () -> {});
            bind.run();
        }
        if (this.block != null && Registries.BLOCK.equals(key)) {
            fluidType = this.getBlock();
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPreRegistered(this.subId(fluidId, "bucket"));
            }
            e.register(Registries.BLOCK, fluidId, this.block::get);
            fluidType = this.getBlock();
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPostRegistered(this.subId(fluidId, "bucket"));
            }
        }
        if (this.bucket != null && Registries.ITEM.equals(key)) {
            fluidType = this.getBucket();
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPreRegistered(this.subId(fluidId, "bucket"));
            }
            e.register(Registries.ITEM, this.subId(fluidId, "bucket"), this.bucket);
            fluidType = this.getBucket();
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPostRegistered(this.subId(fluidId, "bucket"));
            }
        }
        for (TagKey<Fluid> tag : this.fluidTags) {
            TagAdapter.bind(tag, (Fluid)this.source.get(), (Fluid)this.flowing.get());
        }
    }

    public Item asItem() {
        return this.bucket.get();
    }

    public static Builder builder(Supplier<FluidType> typeGenerator) {
        return new Builder(typeGenerator);
    }

    public static Builder builder(FluidType.Properties typeProps) {
        return new Builder(() -> new FluidTypeHL(typeProps));
    }

    public static class Builder {
        protected final Supplier<FluidType> typeGenerator;
        protected final List<TagKey<Fluid>> fluidTags = Lists.newArrayList();
        protected final List<CreativeTab> tabs = Lists.newArrayList();
        protected UnaryOperator<BaseFlowingFluid.Properties> propertyModifier = UnaryOperator.identity();
        protected Function<Supplier<FlowingFluid>, Item> bucket;
        protected Function<Supplier<? extends FlowingFluid>, LiquidBlock> block;
        protected Function<BaseFlowingFluid.Properties, BaseFlowingFluid.Source> sourceGen = BaseFlowingFluid.Source::new;
        protected Function<BaseFlowingFluid.Properties, BaseFlowingFluid.Flowing> flowingGen = BaseFlowingFluid.Flowing::new;
        protected Supplier<Supplier<RenderType>> renderType = () -> RenderType::solid;

        public Builder(Supplier<FluidType> typeGenerator) {
            this.typeGenerator = typeGenerator;
        }

        public Builder withBucket() {
            return this.withBucket(fluid -> new BucketItem((Fluid)fluid.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
        }

        public Builder withBlock() {
            return this.withBlock(flowing -> new LiquidBlock((FlowingFluid)flowing.get(), BlockBehaviour.Properties.of().replaceable().noCollission().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().liquid().sound(SoundType.EMPTY)));
        }

        public Builder propertyModifier(UnaryOperator<BaseFlowingFluid.Properties> propertyModifier) {
            UnaryOperator<BaseFlowingFluid.Properties> pm = this.propertyModifier;
            this.propertyModifier = v -> (BaseFlowingFluid.Properties)propertyModifier.apply((BaseFlowingFluid.Properties)pm.apply((BaseFlowingFluid.Properties)v));
            return this;
        }

        public Builder withBucket(Function<Supplier<FlowingFluid>, Item> bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder withBlock(Function<Supplier<? extends FlowingFluid>, LiquidBlock> block) {
            this.block = block;
            return this;
        }

        public Builder withSource(Function<BaseFlowingFluid.Properties, BaseFlowingFluid.Source> sourceGen) {
            this.sourceGen = sourceGen;
            return this;
        }

        public Builder withFlowing(Function<BaseFlowingFluid.Properties, BaseFlowingFluid.Flowing> flowingGen) {
            this.flowingGen = flowingGen;
            return this;
        }

        public Builder withRenderType(Supplier<Supplier<RenderType>> renderType) {
            this.renderType = renderType;
            return this;
        }

        public Builder addFluidTag(TagKey<Fluid> tag) {
            this.fluidTags.add(tag);
            return this;
        }

        public Builder addFluidTags(List<TagKey<Fluid>> fluidTags) {
            this.fluidTags.addAll(fluidTags);
            return this;
        }

        public Builder addToTab(CreativeTab tab) {
            this.tabs.add(tab);
            return this;
        }

        public Builder addToTabs(Collection<CreativeTab> tab) {
            this.tabs.addAll(tab);
            return this;
        }

        public FluidFactory build() {
            return new FluidFactory(this.typeGenerator, this.bucket, this.propertyModifier, this.block, this.sourceGen, this.flowingGen).withRenderType(this.renderType).addFluidTags(this.fluidTags).addToTabs(this.tabs);
        }
    }
}

