/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.items.glint;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.ToIntBiFunction;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.zeith.hammerlib.api.forge.StreamCodecs;

public interface IGlintProviderType<T> {
    public int getGlint(ItemStack var1, T var2);

    public Codec<T> codec();

    public StreamCodec<? extends ByteBuf, T> streamCodec();

    public static <V> IGlintProviderType<V> simple(ToIntBiFunction<ItemStack, V> getGlint, Codec<V> codec) {
        return IGlintProviderType.simple(getGlint, codec, StreamCodecs.createRegistryAwareStreamCodec(codec));
    }

    public static <B extends ByteBuf, V> IGlintProviderType<V> simple(final ToIntBiFunction<ItemStack, V> getGlint, final Codec<V> codec, final StreamCodec<B, V> streamCodec) {
        return new IGlintProviderType<V>(){

            @Override
            public int getGlint(ItemStack stack, V data) {
                return getGlint.applyAsInt(stack, data);
            }

            @Override
            public Codec<V> codec() {
                return codec;
            }

            @Override
            public StreamCodec<? extends ByteBuf, V> streamCodec() {
                return streamCodec;
            }
        };
    }
}

