/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.items;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import org.zeith.hammerlib.core.adapter.CreativeTabAdapter;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.util.java.tuples.Tuple1;

public class CreativeTab {
    private final Consumer<CreativeModeTab.Builder> factory;
    private final Tuple1.Mutable1<CreativeModeTab> tab = new Tuple1.Mutable1<Object>(null);
    protected final ResourceLocation id;
    protected final List<ItemLike> contents = new ArrayList<ItemLike>();
    protected boolean addHammerLibBefores = true;
    protected final Set<ResourceLocation> tabsBefore = new HashSet<ResourceLocation>();
    protected final Set<ResourceLocation> tabsAfter = new HashSet<ResourceLocation>();

    public CreativeTab(ResourceLocation id, Consumer<CreativeModeTab.Builder> factory) {
        this.id = id;
        Consumer<CreativeModeTab.Builder> factory0 = b -> {
            b.title((Component)Component.translatable((String)Util.makeDescriptionId((String)"creative_tab", (ResourceLocation)id)));
            if (this.addHammerLibBefores && this != HLConstants.HL_TAB) {
                b.withTabsBefore(new ResourceLocation[]{HLConstants.HL_TAB.id()});
            }
            b.withTabsBefore((ResourceLocation[])this.tabsBefore.toArray(ResourceLocation[]::new)).withTabsAfter((ResourceLocation[])this.tabsAfter.toArray(ResourceLocation[]::new));
        };
        this.factory = factory0.andThen(factory);
        CreativeTabAdapter.getCustomTabs().add(this);
    }

    public <T extends ItemLike> T add(T item) {
        this.contents.add(item);
        return item;
    }

    public CreativeModeTab tab() {
        return (CreativeModeTab)this.tab.a();
    }

    public void tab(CreativeModeTab tab) {
        this.tab.setA(tab);
    }

    public ResourceLocation id() {
        return this.id;
    }

    public Consumer<CreativeModeTab.Builder> factory() {
        return this.factory;
    }

    public List<ItemLike> contents() {
        return this.contents;
    }

    public CreativeTab putAfter(CreativeTab prevTab) {
        this.tabsBefore.add(prevTab.id());
        return this;
    }

    public CreativeTab putAfter(ResourceLocation prevTab) {
        this.tabsBefore.add(prevTab);
        return this;
    }

    public CreativeTab putBefore(CreativeTab afterTab) {
        this.tabsAfter.add(afterTab.id());
        return this;
    }

    public CreativeTab putBefore(ResourceLocation afterTab) {
        this.tabsAfter.add(afterTab);
        return this;
    }

    public void register(Function<CreativeTab, CreativeModeTab> e) {
        this.tab(e.apply(this));
        CreativeTabAdapter.getRegistered().put(this.tab(), this);
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface RegisterTab {
    }
}

