/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.io.serializers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.api.io.NBTSerializationHelper;
import org.zeith.hammerlib.api.io.serializers.INBTSerializer;

public class RecordNBTSerializer<T extends Record>
implements INBTSerializer<T> {
    protected final Class<T> record;
    protected final RecordComponent[] components;
    protected final String[] componentNames;
    protected final Function<T, Object>[] suppliers;
    protected final Function<Object[], T> factory;

    public RecordNBTSerializer(Class<T> record) {
        if (!record.isRecord()) {
            throw new IllegalArgumentException(String.valueOf(record) + " must be a record.");
        }
        this.record = record;
        this.components = record.getRecordComponents();
        this.suppliers = new Function[this.components.length];
        this.componentNames = new String[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            Method m = record.getDeclaredMethod(this.components[i].getName(), new Class[0]);
            this.suppliers[i] = inst -> this.getField(inst, m);
            NBTSerializable n = this.components[i].getDeclaredAnnotation(NBTSerializable.class);
            this.componentNames[i] = n != null ? n.value() : this.components[i].getName();
        }
        Constructor<T> ctor = record.getDeclaredConstructor((Class[])Arrays.stream(this.components).map(RecordComponent::getType).toArray(Class[]::new));
        this.factory = args -> this.newInstance((Object[])args, ctor);
    }

    private T newInstance(Object[] args, Constructor<T> ctor) {
        return (T)((Record)ctor.newInstance(args));
    }

    private Object getField(T inst, Method m) {
        return m.invoke(inst, new Object[0]);
    }

    @Override
    public void serialize(HolderLookup.Provider provider, String key, @NotNull T value, CompoundTag nbt) {
        CompoundTag inner = new CompoundTag();
        for (int i = 0; i < this.components.length; ++i) {
            RecordComponent component = this.components[i];
            NBTSerializationHelper.serializeField(provider, component.getType(), this.suppliers[i].apply(value), inner, this.componentNames[i]);
        }
        nbt.put(key, (Tag)inner);
    }

    @Override
    @Nullable
    public T deserialize(HolderLookup.Provider provider, String key, CompoundTag nbt) {
        CompoundTag inner = nbt.getCompound(key);
        Object[] coms = new Object[this.components.length];
        for (int i = 0; i < coms.length; ++i) {
            RecordComponent com = this.components[i];
            coms[i] = NBTSerializationHelper.deserializeField(provider, com.getType(), inner, this.componentNames[i]);
        }
        return (T)((Record)this.factory.apply(coms));
    }
}

