/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.actions;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.Contract;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.abstractions.actions.ContinuousLevelAction;
import org.zeith.hammerlib.abstractions.actions.LevelAction;
import org.zeith.hammerlib.abstractions.actions.RunnableLevelAction;

@EventBusSubscriber
public class WorldSavedActions
extends SavedData {
    private final ServerLevel level;
    private final List<RunnableLevelAction> actions = new ArrayList<RunnableLevelAction>();
    private final List<ContinuousLevelAction> continuousActions = new ArrayList<ContinuousLevelAction>();

    public WorldSavedActions(ServerLevel level) {
        this.level = level;
    }

    public WorldSavedActions(ServerLevel level, CompoundTag nbt) {
        this.level = level;
        ListTag actionsTag = nbt.getList("Actions", 10);
        for (int i = 0; i < actionsTag.size(); ++i) {
            CompoundTag tag = actionsTag.getCompound(i);
            LevelAction action = LevelAction.read((Level)level, tag).orElse(null);
            if (action == null) {
                HammerLib.LOG.warn("Unable to find level action type \"{}\" (with data {})", (Object)tag.getString("Type"), (Object)tag.getCompound("Data"));
                continue;
            }
            if (!(action instanceof RunnableLevelAction)) {
                HammerLib.LOG.warn("Level action type \"{}\" is not runnable! (with data {})", (Object)tag.getString("Type"), (Object)tag.getCompound("Data"));
                continue;
            }
            RunnableLevelAction r = (RunnableLevelAction)action;
            if (r instanceof ContinuousLevelAction) {
                ContinuousLevelAction c = (ContinuousLevelAction)r;
                this.continuousActions.add(c);
                continue;
            }
            this.actions.add(r);
        }
    }

    public void tick() {
        boolean hasNone;
        boolean bl = hasNone = this.actions.isEmpty() && this.continuousActions.isEmpty();
        while (!this.actions.isEmpty()) {
            RunnableLevelAction a = this.actions.remove(0);
            if (a instanceof ContinuousLevelAction) {
                ContinuousLevelAction c = (ContinuousLevelAction)a;
                this.continuousActions.add(c);
                continue;
            }
            a.run(this.level);
        }
        for (int i = 0; i < this.continuousActions.size(); ++i) {
            ContinuousLevelAction a = this.continuousActions.get(i);
            a.run(this.level);
            if (!a.isDone()) continue;
            this.continuousActions.remove(i);
            --i;
        }
        if (hasNone && this.continuousActions.isEmpty()) {
            return;
        }
        this.setDirty();
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag actionsTag = new ListTag();
        for (RunnableLevelAction runnableLevelAction : this.actions) {
            actionsTag.add((Object)LevelAction.write((Level)this.level, runnableLevelAction));
        }
        for (RunnableLevelAction runnableLevelAction : this.continuousActions) {
            actionsTag.add((Object)LevelAction.write((Level)this.level, runnableLevelAction));
        }
        nbt.put("Actions", (Tag)actionsTag);
        return nbt;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public static boolean enqueue(ServerLevel level, RunnableLevelAction action) {
        WorldSavedActions actions = WorldSavedActions.get(level);
        if (action == null || actions == null) {
            return false;
        }
        if (action instanceof ContinuousLevelAction) {
            ContinuousLevelAction c = (ContinuousLevelAction)action;
            actions.continuousActions.add(c);
        } else {
            actions.actions.add(action);
        }
        actions.setDirty();
        return true;
    }

    @Contract(value="_ -> _")
    public static WorldSavedActions get(ServerLevel level) {
        return level != null ? (WorldSavedActions)level.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new WorldSavedActions(level), (nbt, lookup) -> new WorldSavedActions(level, (CompoundTag)nbt), null), "hammerlib_level_actions") : null;
    }

    @SubscribeEvent
    public static void levelTick(LevelTickEvent.Pre e) {
        Level level = e.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        WorldSavedActions.get(sl).tick();
    }
}

