/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;
import net.mehvahdjukaar.smarterfarmers.EatFoodGoal;
import net.mehvahdjukaar.smarterfarmers.mixins.VillagerAccessor;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmarterFarmers {
    public static final String MOD_ID = "smarterfarmers";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean QUARK = PlatHelper.isModLoaded((String)"quark");
    public static final TagKey<Block> HARVEST_ON_FARMLAND_SPECIAL = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)SmarterFarmers.res("harvest_on_farmland"));
    public static final TagKey<Block> HARVEST_ON_TILLABLE_NO_REPLANT = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)SmarterFarmers.res("harvestable_on_tillable_no_replant"));
    public static final TagKey<Block> HARVEST_ON_TILLABLE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)SmarterFarmers.res("harvest_on_tillable"));
    public static final TagKey<Block> FARMER_TILLABLE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)SmarterFarmers.res("tillable"));
    public static final TagKey<Block> VALID_FARMLAND = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)SmarterFarmers.res("farmland"));
    public static final TagKey<Block> HARVEST_BLACKLIST = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)SmarterFarmers.res("harvest_blacklist"));
    public static final TagKey<Item> EAT_BLACKLIST = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SmarterFarmers.res("villagers_cant_eat"));
    public static final TagKey<Item> STEM_SEEDS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SmarterFarmers.res("stem_seeds"));
    public static final Supplier<Boolean> PICKUP_FOOD;
    public static final Supplier<Boolean> EAT_FOOD;
    public static final Supplier<Boolean> DEBUG_RENDERERS;
    public static final Supplier<Boolean> PLANT_ON_TILLABLE;
    public static final Supplier<Integer> TIME_TO_HARVEST;
    public static final ModConfigHolder CONFIG;
    private static final Map<Item, Integer> OLD_FOOD_POINTS;

    public static ResourceLocation res(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        MoonlightEventsHelper.addListener(SmarterFarmers::onVillagerBrainInitialize, IVillagerBrainEvent.class);
    }

    public static void setupWithTags(RegistryAccess registryAccess, boolean client) {
        if (OLD_FOOD_POINTS.isEmpty()) {
            OLD_FOOD_POINTS.putAll(Villager.FOOD_POINTS);
        }
        try {
            HashMap<Item, Integer> newMap = new HashMap<Item, Integer>(OLD_FOOD_POINTS);
            for (Item i : BuiltInRegistries.ITEM) {
                ItemStack defaultStack = i.getDefaultInstance();
                FoodProperties foodProperties = (FoodProperties)defaultStack.get(DataComponents.FOOD);
                if (foodProperties == null || defaultStack.getOrDefault(DataComponents.RARITY, (Object)Rarity.COMMON) != Rarity.COMMON || defaultStack.is(EAT_BLACKLIST) || !foodProperties.effects().stream().allMatch(e -> ((MobEffect)e.effect().getEffect().value()).isBeneficial()) || i.hasCraftingRemainingItem() || i.getDefaultMaxStackSize() <= 1) continue;
                newMap.put(i, (int)Math.max(1.0f, (float)(foodProperties.nutrition() * 2) / 3.0f));
            }
            VillagerAccessor.setFoodPoints(newMap);
        }
        catch (Exception e2) {
            LOGGER.warn("Failed to add custom foods to villagers", (Throwable)e2);
        }
    }

    public static void onVillagerBrainInitialize(IVillagerBrainEvent event) {
        if (EAT_FOOD.get().booleanValue()) {
            event.addTaskToActivity(Activity.MEET, Pair.of((Object)7, (Object)((Object)new EatFoodGoal(100, 140))));
        }
    }

    public static void spawnEatingParticles(AbstractVillager villager) {
        Vec3 pos = new Vec3(0.0, 0.0, 0.4);
        pos = pos.yRot(-villager.yBodyRot * ((float)Math.PI / 180));
        pos = pos.add(villager.getX(), villager.getEyeY(), villager.getZ());
        ItemStack stack = villager.getMainHandItem();
        Level level = villager.level();
        level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), pos.x + (double)Mth.randomBetween((RandomSource)level.random, (float)-0.05f, (float)0.05f), pos.y - 0.4 + (double)Mth.randomBetween((RandomSource)level.random, (float)-0.05f, (float)0.05f), pos.z + (double)Mth.randomBetween((RandomSource)level.random, (float)-0.05f, (float)0.05f), 0.03, 0.05, 0.03);
    }

    static {
        ConfigBuilder builder = ConfigBuilder.create((String)MOD_ID, (ConfigType)ConfigType.COMMON);
        builder.push("general");
        PICKUP_FOOD = builder.comment("If true, villagers will pick up food items from the regardless of mob griefing gamerule. Needed since with mob griefing on they wont be able to breed.").define("pickup_food_override", true);
        EAT_FOOD = builder.comment("If true, villagers will eat food items they pick up. Eating food will heal them").define("eat_food", true);
        TIME_TO_HARVEST = builder.comment("Time for a farmer to harvest a crop once it reached its destination").define("time_to_harvest", 40, 1, 1000);
        DEBUG_RENDERERS = PlatHelper.isDev() ? () -> true : builder.comment("If true, will render debug info for farmers. Only works in single player").define("debug_renderer", false);
        PLANT_ON_TILLABLE = builder.comment("If true, farmers will plant crops on tillable blocks (like dirt) by first tilling them. Valid blocks are controlled by farmer_tillable tag").define("plant_on_tillable", false);
        builder.pop();
        CONFIG = builder.build();
        OLD_FOOD_POINTS = new HashMap<Item, Integer>();
    }
}

