/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread_common_forge.events;

import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.netherportalspread_common_forge.config.ConfigHandler;
import com.natamus.netherportalspread_common_forge.util.Util;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalShape;

public class SpreadEvent {
    private static final HashMap<Level, CopyOnWriteArrayList<BlockPos>> portals_to_process = new HashMap();
    private static final HashMap<Level, Integer> levelTicks = new HashMap();

    public static void onWorldLoad(ServerLevel level) {
        Util.attemptSpreadBlockProcess((Level)level);
        if (!WorldFunctions.isNether((Level)level)) {
            Util.loadPortalsFromWorld((Level)level);
        }
    }

    public static void onWorldTick(ServerLevel level) {
        int leveltick;
        if (WorldFunctions.isNether((Level)level)) {
            return;
        }
        if (((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals_to_process, (Object)level, k -> new CopyOnWriteArrayList())).size() > 0) {
            BlockPos portal = portals_to_process.get(level).get(0);
            if (!((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(Util.portals, (Object)level, k -> new CopyOnWriteArrayList())).contains(portal) && !((HashMap)HashMapFunctions.computeIfAbsent(Util.preventedportals, (Object)level, k -> new HashMap())).containsKey(portal)) {
                Util.validatePortalAndAdd((Level)level, portal);
            }
            portals_to_process.get(level).remove(0);
        }
        if ((leveltick = ((Integer)HashMapFunctions.computeIfAbsent(levelTicks, (Object)level, k -> 1)).intValue()) % ConfigHandler.spreadDelayTicks != 0) {
            levelTicks.put((Level)level, leveltick + 1);
            return;
        }
        levelTicks.put((Level)level, 1);
        for (BlockPos portal : (CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(Util.portals, (Object)level, k -> new CopyOnWriteArrayList())) {
            Util.spreadNextBlock((Level)level, portal);
        }
    }

    public static void onPortalSpawn(Level level, BlockPos pos, PortalShape shape) {
        if (level == null) {
            return;
        }
        if (level.isClientSide) {
            return;
        }
        if (WorldFunctions.isNether((Level)level)) {
            return;
        }
        ((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals_to_process, (Object)level, k -> new CopyOnWriteArrayList())).add(pos);
    }

    public static void onDimensionChange(ServerLevel level, ServerPlayer player) {
        if (level.isClientSide) {
            return;
        }
        if (WorldFunctions.isNether((Level)level)) {
            return;
        }
        BlockPos ppos = player.blockPosition();
        ((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals_to_process, (Object)level, k -> new CopyOnWriteArrayList())).add(ppos);
    }
}

