/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.structure;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractStructureHandler
implements IStructureHandler {
    private Future<Blueprint> blueprintFuture = null;
    private Blueprint blueprint;
    private String md5;
    private RotationMirror rotMir;
    private Level world;
    private BlockPos worldPos;

    public AbstractStructureHandler(Level world, BlockPos worldPos, Future<Blueprint> blueprintFuture, RotationMirror rotMir) {
        this.world = world;
        this.worldPos = worldPos;
        this.rotMir = rotMir;
        this.blueprintFuture = blueprintFuture;
    }

    public AbstractStructureHandler(Level world, BlockPos pos, Blueprint blueprint, RotationMirror rotMir) {
        this.world = world;
        this.worldPos = pos;
        this.rotMir = rotMir;
        this.blueprint = blueprint;
    }

    @Override
    public void triggerSuccess(BlockPos pos, List<ItemStack> requiredRes, boolean placement) {
        BlockEntity be = this.getWorld().getBlockEntity(this.getProgressPosInWorld(pos));
        if (be instanceof IBlueprintDataProviderBE) {
            if (this.getProgressPosInWorld(pos).equals((Object)this.worldPos)) {
                ((IBlueprintDataProviderBE)be).setBlueprintPath(StructurePacks.getStructurePack(this.getBluePrint().getPackName()).getSubPath(this.getBluePrint().getFilePath().resolve(this.getBluePrint().getFileName())) + ".blueprint");
            }
            ((IBlueprintDataProviderBE)be).setPackName(this.getBluePrint().getPackName());
        }
    }

    @Override
    public boolean hasBluePrint() {
        return this.blueprint != null;
    }

    @Override
    public void setMd5(String md5) {
        this.md5 = md5;
    }

    @Override
    public void setBlueprint(Blueprint blueprint) {
        this.blueprint = blueprint;
    }

    @Override
    public Blueprint getBluePrint() {
        if (this.blueprint == null && this.blueprintFuture != null && this.blueprintFuture.isDone()) {
            try {
                this.blueprint = this.blueprintFuture.get();
                this.blueprint.setRotationMirror(this.rotMir, this.world);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return this.blueprint;
    }

    @Override
    public Level getWorld() {
        return this.world;
    }

    @Override
    public String getMd5() {
        return this.md5;
    }

    @Override
    public BlockPos getWorldPos() {
        return this.worldPos;
    }

    @Override
    public RotationMirror getRotationMirror() {
        return this.rotMir;
    }

    @Override
    public boolean isReady() {
        return this.blueprint != null || this.blueprintFuture != null && this.blueprintFuture.isDone();
    }
}

