/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.management.Manager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class UndoRedoMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"undo_redo", UndoRedoMessage::new);
    private final int id;
    private final boolean undo;

    public UndoRedoMessage(int id, boolean undo) {
        super(TYPE);
        this.undo = undo;
        this.id = id;
    }

    protected UndoRedoMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.id = buf.readInt();
        this.undo = buf.readBoolean();
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.undo);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        if (!player.isCreative()) {
            return;
        }
        if (this.undo) {
            Manager.undo((Player)player, this.id);
        } else {
            Manager.redo((Player)player, this.id);
        }
    }
}

