/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.client.gui.util.ItemPositionsStorage;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.operations.RemoveBlockOperation;
import com.ldtteam.structurize.operations.RemoveFilteredOperation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RemoveBlockMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"remove_block", RemoveBlockMessage::new);
    private List<ItemPositionsStorage> toRemove = new ArrayList<ItemPositionsStorage>();

    protected RemoveBlockMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.toRemove.add(new ItemPositionsStorage(buf));
        }
    }

    public RemoveBlockMessage(ItemPositionsStorage itemPositionsStorage) {
        super(TYPE);
        this.toRemove = List.of(itemPositionsStorage);
    }

    public RemoveBlockMessage(List<ItemPositionsStorage> itemPositionsStorageList) {
        super(TYPE);
        this.toRemove = itemPositionsStorageList;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.toRemove.size());
        for (ItemPositionsStorage positionsStorage : this.toRemove) {
            positionsStorage.serialize(buf);
        }
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        if (!player.isCreative()) {
            return;
        }
        if (this.toRemove.size() > 1) {
            Manager.addToQueue(new RemoveFilteredOperation(player, this.toRemove));
            return;
        }
        if (!this.toRemove.isEmpty()) {
            Manager.addToQueue(new RemoveBlockOperation(player, this.toRemove.get(0)));
        }
    }
}

