/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.util.PlacerholderFillOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class FillTopPlaceholderMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"fill_top_placeholder", FillTopPlaceholderMessage::new);
    private final BlockPos from;
    private final BlockPos to;
    private final double yStretch;
    private final double circleRadiusMult;
    private final int heightOffset;
    private final int minDistToBlocks;

    protected FillTopPlaceholderMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.from = buf.readBlockPos();
        this.to = buf.readBlockPos();
        this.yStretch = buf.readDouble();
        this.circleRadiusMult = buf.readDouble();
        this.heightOffset = buf.readInt();
        this.minDistToBlocks = buf.readInt();
    }

    public FillTopPlaceholderMessage(BlockPos pos1, BlockPos pos2, double yStretch, double circleRadiusMult, int heightOffset, int minDistToBlocks) {
        super(TYPE);
        this.from = pos1;
        this.to = pos2;
        this.yStretch = yStretch;
        this.circleRadiusMult = circleRadiusMult;
        this.heightOffset = heightOffset;
        this.minDistToBlocks = minDistToBlocks;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.from);
        buf.writeBlockPos(this.to);
        buf.writeDouble(this.yStretch);
        buf.writeDouble(this.circleRadiusMult);
        buf.writeInt(this.heightOffset);
        buf.writeInt(this.minDistToBlocks);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        if (!player.isCreative()) {
            return;
        }
        Manager.addToQueue(new PlacerholderFillOperation(this.from, this.to, (Player)player, this.yStretch, this.circleRadiusMult, this.heightOffset, this.minDistToBlocks));
    }
}

