/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui.util;

import com.ldtteam.structurize.api.ItemStorage;
import com.ldtteam.structurize.api.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class ItemPositionsStorage {
    public final ItemStorage itemStorage;
    public final List<BlockPos> positions = new ArrayList<BlockPos>();

    public ItemPositionsStorage(ItemStorage itemStorage) {
        this.itemStorage = itemStorage;
    }

    public ItemPositionsStorage(RegistryFriendlyByteBuf buf) {
        this.itemStorage = new ItemStorage(buf);
        int count = buf.readVarInt();
        for (int i = 0; i < count; ++i) {
            this.positions.add(new BlockPos(buf.readVarInt(), buf.readVarInt(), buf.readVarInt()));
        }
    }

    public void addPos(BlockPos pos) {
        this.positions.add(pos);
    }

    public void addItemAndPos(ItemStorage toAdd, BlockPos pos) {
        if (!toAdd.equals(this.itemStorage)) {
            Log.getLogger().warn("Tried to add a different item to the item storage!", (Throwable)new Exception());
            return;
        }
        this.positions.add(pos);
        this.itemStorage.setAmount(this.positions.size());
    }

    public void removePos(BlockPos pos) {
        this.positions.remove(pos);
    }

    public boolean isEmpty() {
        return this.positions.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemPositionsStorage)) {
            return false;
        }
        ItemPositionsStorage that = (ItemPositionsStorage)o;
        return Objects.equals(this.itemStorage, that.itemStorage);
    }

    public int hashCode() {
        return Objects.hashCode(this.itemStorage);
    }

    public void serialize(RegistryFriendlyByteBuf buf) {
        this.itemStorage.serialize(buf);
        buf.writeVarInt(this.positions.size());
        for (BlockPos pos : this.positions) {
            buf.writeVarInt(pos.getX());
            buf.writeVarInt(pos.getY());
            buf.writeVarInt(pos.getZ());
        }
    }
}

