/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.common.util.BlockToItemHelper;
import com.ldtteam.structurize.api.ItemStackUtils;
import com.ldtteam.structurize.api.ItemStorage;
import com.ldtteam.structurize.api.constants.Constants;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WindowBlockGetterContents
extends BOWindow {
    public WindowBlockGetterContents(Blueprint blueprint, Level realLevel, Collection<Entity> boundedEntities) {
        this((BlockGetter)blueprint, realLevel, new BlockPos(blueprint.getMinX(), blueprint.getMinBuildHeight(), blueprint.getMinZ()), new BlockPos(blueprint.getMaxX() - 1, blueprint.getMaxBuildHeight() - 1, blueprint.getMaxZ() - 1), boundedEntities);
    }

    public WindowBlockGetterContents(BlockGetter blockGetter, @Nullable Level realLevel, BlockPos start, BlockPos end, Collection<Entity> boundedEntities) {
        super(Constants.resLocStruct("gui/windowcontents.xml"));
        HashMap<Item, ItemStorage> blocks = new HashMap<Item, ItemStorage>();
        HashMap blockItemHandlers = new HashMap();
        HashMap<Item, ItemStorage> entities = new HashMap<Item, ItemStorage>();
        HashMap entityItemHandlers = new HashMap();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)start, (BlockPos)end)) {
            BlockState blockState = blockGetter.getBlockState(pos);
            BlockEntity blockEntity = blockGetter.getBlockEntity(pos);
            this.addAmountToMap(blocks, BlockToItemHelper.getItemStack((BlockState)blockState, (BlockEntity)blockEntity, (Player)Minecraft.getInstance().player));
            if (blockEntity != null && blockEntity.getLevel() == null) {
                ItemStackUtils.ITEM_HANDLER_FAKE_LEVEL.get(realLevel).withFakeLevelContext(blockState, blockEntity, realLevel, level -> ItemStackUtils.getItemHandlersFromProvider(blockEntity, pos, blockState).forEach(i -> ItemStackUtils.deepExtractItemHandler(i, stack -> this.addAmountToMap(blockItemHandlers, (ItemStack)stack))));
                continue;
            }
            ItemStackUtils.getItemHandlersFromProvider(blockEntity, pos, blockState).forEach(i -> ItemStackUtils.deepExtractItemHandler(i, stack -> this.addAmountToMap(blockItemHandlers, (ItemStack)stack)));
        }
        for (Entity entity : boundedEntities) {
            this.addAmountToMap(entities, ItemStackUtils.getEntitySpawningItem(entity));
            ItemStackUtils.getItemStacksOfEntity(entity).forEach(stack -> this.addAmountToMap(entityItemHandlers, (ItemStack)stack));
        }
        ArrayList blockList = new ArrayList(blocks.values());
        ArrayList blockItemHandlerList = new ArrayList(blockItemHandlers.values());
        ArrayList entityList = new ArrayList(entities.values());
        ArrayList entityItemHandlerList = new ArrayList(entityItemHandlers.values());
        Comparator alphabeticalOrder = (i1, i2) -> i1.getItemStack().getHoverName().getString().compareTo(i2.getItemStack().getHoverName().getString());
        blockList.sort(alphabeticalOrder);
        blockItemHandlerList.sort(alphabeticalOrder);
        entityList.sort(alphabeticalOrder);
        entityItemHandlerList.sort(alphabeticalOrder);
        ((ScrollingList)this.findPaneOfTypeByID("blocks", ScrollingList.class)).setDataProvider(blockList::size, (idx, pane) -> this.updateItem((ItemStorage)blockList.get(idx), pane));
        ((ScrollingList)this.findPaneOfTypeByID("block_item_handlers", ScrollingList.class)).setDataProvider(blockItemHandlerList::size, (idx, pane) -> this.updateItem((ItemStorage)blockItemHandlerList.get(idx), pane));
        ((ScrollingList)this.findPaneOfTypeByID("entities", ScrollingList.class)).setDataProvider(entityList::size, (idx, pane) -> this.updateItem((ItemStorage)entityList.get(idx), pane));
        ((ScrollingList)this.findPaneOfTypeByID("entity_item_handlers", ScrollingList.class)).setDataProvider(entityItemHandlerList::size, (idx, pane) -> this.updateItem((ItemStorage)entityItemHandlerList.get(idx), pane));
    }

    private void addAmountToMap(Map<Item, ItemStorage> itemSet, @Nullable ItemStack blockAsItem) {
        if (blockAsItem != null) {
            itemSet.computeIfAbsent(blockAsItem.getItem(), i -> new ItemStorage(blockAsItem.copyWithCount(1), 0, true, true)).addAmount(Math.max(1, blockAsItem.getCount()));
        }
    }

    private void updateItem(ItemStorage itemStorage, Pane pane) {
        ((ItemIcon)pane.findPaneOfTypeByID("icon", ItemIcon.class)).setItem(itemStorage.getItemStack());
        ((Text)pane.findPaneOfTypeByID("registry_key", Text.class)).setText(itemStorage.getItemStack().getHoverName());
        ((Text)pane.findPaneOfTypeByID("amount", Text.class)).setText(Component.literal((String)Integer.toString(itemStorage.getAmount())));
    }
}

