/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blockentities.interfaces;

import com.ldtteam.structurize.api.BlockPosUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Tuple;

public interface IBlueprintDataProviderBE {
    public static final String TAG_SCHEMATIC_NAME = "schematicName";
    public static final String TAG_CORNER_ONE = "corner1";
    public static final String TAG_CORNER_TWO = "corner2";
    public static final String TAG_TAG_POS = "tagPos";
    public static final String TAG_TAG_NAME = "tagName";
    public static final String TAG_TAG_NAME_LIST = "tagNameList";
    public static final String TAG_POS_TAG_MAP = "posTagMap";
    public static final String TAG_BLUEPRINTDATA = "blueprintDataProvider";
    public static final String TAG_PATH = "path";
    public static final String TAG_PACK = "pack";

    public String getSchematicName();

    public void setSchematicName(String var1);

    public Map<BlockPos, List<String>> getPositionedTags();

    public void setPositionedTags(Map<BlockPos, List<String>> var1);

    public Tuple<BlockPos, BlockPos> getSchematicCorners();

    default public Tuple<BlockPos, BlockPos> getInWorldCorners() {
        Tuple<BlockPos, BlockPos> schematicCorners = this.getSchematicCorners();
        return new Tuple((Object)this.getTilePos().offset((Vec3i)schematicCorners.getA()), (Object)this.getTilePos().offset((Vec3i)this.getSchematicCorners().getB()));
    }

    public void setSchematicCorners(BlockPos var1, BlockPos var2);

    default public void writeSchematicDataToNBT(CompoundTag originalCompound) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.putString(TAG_SCHEMATIC_NAME, this.getSchematicName());
        BlockPosUtil.writeToNBT(compoundNBT, TAG_CORNER_ONE, (BlockPos)this.getSchematicCorners().getA());
        BlockPosUtil.writeToNBT(compoundNBT, TAG_CORNER_TWO, (BlockPos)this.getSchematicCorners().getB());
        IBlueprintDataProviderBE.writeMapToCompound(compoundNBT, this.getPositionedTags());
        originalCompound.put(TAG_BLUEPRINTDATA, (Tag)compoundNBT);
        compoundNBT.putString(TAG_PACK, this.getPackName() == null ? "" : this.getPackName());
        compoundNBT.putString(TAG_PATH, this.getBlueprintPath() == null ? "" : this.getBlueprintPath());
    }

    public static void writeMapToCompound(CompoundTag compoundNBT, Map<BlockPos, List<String>> tagPosMap) {
        ListTag tagPosList = new ListTag();
        for (Map.Entry<BlockPos, List<String>> entry : tagPosMap.entrySet()) {
            CompoundTag posTagCompound = new CompoundTag();
            BlockPosUtil.writeToNBT(posTagCompound, TAG_TAG_POS, entry.getKey());
            ListTag tagList = new ListTag();
            for (String tag : entry.getValue()) {
                CompoundTag tagCompound = new CompoundTag();
                tagCompound.putString(TAG_TAG_NAME, tag);
                tagList.add((Object)tagCompound);
            }
            posTagCompound.put(TAG_TAG_NAME_LIST, (Tag)tagList);
            tagPosList.add((Object)posTagCompound);
        }
        compoundNBT.put(TAG_POS_TAG_MAP, (Tag)tagPosList);
    }

    default public void readSchematicDataFromNBT(CompoundTag originalCompound) {
        if (!originalCompound.contains(TAG_BLUEPRINTDATA)) {
            return;
        }
        CompoundTag compoundNBT = originalCompound.getCompound(TAG_BLUEPRINTDATA);
        this.setSchematicName(compoundNBT.getString(TAG_SCHEMATIC_NAME));
        BlockPos corner1 = BlockPosUtil.readFromNBT(compoundNBT, TAG_CORNER_ONE);
        BlockPos corner2 = BlockPosUtil.readFromNBT(compoundNBT, TAG_CORNER_TWO);
        this.setSchematicCorners(corner1, corner2);
        this.setPositionedTags(IBlueprintDataProviderBE.readTagPosMapFrom(compoundNBT));
    }

    public static Map<BlockPos, List<String>> readTagPosMapFrom(CompoundTag compoundNBT) {
        HashMap<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
        if (!compoundNBT.contains(TAG_POS_TAG_MAP)) {
            return tagPosMap;
        }
        ListTag tagPosMapNBT = compoundNBT.getList(TAG_POS_TAG_MAP, 10);
        for (Tag tagPosMapEntry : tagPosMapNBT) {
            if (!(tagPosMapEntry instanceof CompoundTag)) continue;
            CompoundTag entry = (CompoundTag)tagPosMapEntry;
            BlockPos tagPos = BlockPosUtil.readFromNBT(entry, TAG_TAG_POS);
            HashSet<String> tagList = new HashSet<String>();
            ListTag tagListNbt = entry.getList(TAG_TAG_NAME_LIST, 10);
            for (Tag tagEntryNBT : tagListNbt) {
                if (!(tagEntryNBT instanceof CompoundTag)) continue;
                CompoundTag tagEntry = (CompoundTag)tagEntryNBT;
                tagList.add(tagEntry.getString(TAG_TAG_NAME));
            }
            tagPosMap.put(tagPos, new ArrayList(tagList));
        }
        return tagPosMap;
    }

    default public void removeTag(BlockPos pos, String tag) {
        Map<BlockPos, List<String>> data = this.getPositionedTags();
        if (data.containsKey(pos)) {
            data.get(pos).remove(tag);
            if (data.get(pos).isEmpty()) {
                data.remove(pos);
            }
        }
        this.setPositionedTags(data);
    }

    default public void addTag(BlockPos pos, String tag) {
        Map<BlockPos, List<String>> data = this.getPositionedTags();
        if (data.containsKey(pos)) {
            data.get(pos).add(tag);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(tag);
            data.put(pos, list);
        }
        this.setPositionedTags(data);
    }

    default public Map<BlockPos, List<String>> getWorldTagPosMap() {
        HashMap<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
        for (Map.Entry<BlockPos, List<String>> entry : this.getPositionedTags().entrySet()) {
            tagPosMap.put(entry.getKey().offset((Vec3i)this.getTilePos()), entry.getValue());
        }
        return tagPosMap;
    }

    default public Map<String, Set<BlockPos>> getWorldTagNamePosMap() {
        HashMap<String, Set<BlockPos>> tagNamePosMap = new HashMap<String, Set<BlockPos>>();
        for (Map.Entry<BlockPos, List<String>> entry : this.getPositionedTags().entrySet()) {
            for (String tagName : entry.getValue()) {
                tagNamePosMap.computeIfAbsent(tagName, new Function<String, Set<BlockPos>>(this){

                    @Override
                    public Set<BlockPos> apply(String s) {
                        return new HashSet<BlockPos>();
                    }
                }).add(entry.getKey().offset((Vec3i)this.getTilePos()));
            }
        }
        return tagNamePosMap;
    }

    default public BlockPos getRealWorldPos(BlockPos relativePos) {
        return relativePos.offset((Vec3i)this.getTilePos());
    }

    public BlockPos getTilePos();

    public ClientboundBlockEntityDataPacket getUpdatePacket();

    public void setBlueprintPath(String var1);

    public void setPackName(String var1);

    public String getPackName();

    public String getBlueprintPath();
}

