/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.entity.CounterBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CounterBlock
extends BaseKitchenBlock {
    public static final MapCodec<CounterBlock> CODEC = RecordCodecBuilder.mapCodec(it -> it.group((App)DyeColor.CODEC.fieldOf("color").orElse(null).forGetter(CounterBlock::getColor), (App)CounterBlock.propertiesCodec()).apply((Applicative)it, CounterBlock::new));
    private final DyeColor color;

    public CounterBlock(@Nullable DyeColor color, BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.STONE).strength(5.0f, 10.0f));
        this.color = color;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FLIPPED});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CounterBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (itemStack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (this.tryRecolorBlock(state, itemStack, level, pos, player, blockHitResult)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (itemStack.getItem() == ModItems.preservationChamber) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        CounterBlockEntity counter = (CounterBlockEntity)level.getBlockEntity(pos);
        if (blockHitResult.getDirection() == state.getValue((Property)FACING) && counter.getDoorAnimator().isForcedOpen()) {
            itemStack = counter.insertItemStacked(itemStack, false);
            player.setItemInHand(hand, itemStack);
            return ItemInteractionResult.SUCCESS;
        }
        if (blockHitResult.getDirection() == Direction.UP && itemStack.getItem() instanceof BlockItem) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(itemStack, state, level, pos, player, hand, blockHitResult);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult rayTraceResult) {
        CounterBlockEntity counter = (CounterBlockEntity)level.getBlockEntity(pos);
        if (rayTraceResult.getDirection() == state.getValue((Property)FACING) && counter != null && player.isShiftKeyDown()) {
            counter.getDoorAnimator().toggleForcedOpen();
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide) {
            Balm.getNetworking().openGui(player, (MenuProvider)counter);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return (BlockState)state.setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(this.shouldBePlacedFlipped(context, (Direction)state.getValue((Property)FACING))));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? CounterBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.counter.get()), CounterBlockEntity::clientTick) : CounterBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.counter.get()), CounterBlockEntity::serverTick);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    protected void appendHoverDescriptionText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.cookingforblockheads.counter.description").withStyle(ChatFormatting.GRAY));
    }

    @Override
    protected BlockState getDyedStateOf(BlockState state, @Nullable DyeColor color) {
        CounterBlock block = color == null ? ModBlocks.counter : ModBlocks.dyedCounters[color.ordinal()];
        return (BlockState)((BlockState)block.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FLIPPED, (Comparable)((Boolean)state.getValue((Property)FLIPPED)));
    }
}

