// priority: 0

onEvent('item.registry', event => {
	event.create('metal/double_sheet/electrum')   // Display names are in kubejs/assets/kubejs/en_us.json
	event.create('metal/double_sheet/constantan') // because having slashes in registry names breaks .displayName()
	event.create('metal/double_sheet/aluminum')
	event.create('metal/double_sheet/lead')
	event.create('metal/double_sheet/uranium')

	event.create('clean_gem_dust/amethyst')
	event.create('clean_gem_dust/opal')
	event.create('clean_gem_dust/pyrite')
	event.create('clean_gem_dust/ruby')
	event.create('clean_gem_dust/sapphire')
	event.create('clean_gem_dust/topaz')
	event.create('clean_amethyst_powder').texture('kubejs:item/amethyst_old') // Old item version for compatibility

	event.create('misc_mats/andesite_alloy/rod')
	event.create('misc_mats/andesite_alloy/sheet')
	event.create('misc_mats/netherite/rod')

	event.create('misc_mats/healing_salve').rarity('uncommon')
	event.create('misc_mats/mineral_mix')
	event.create('misc_mats/ceramic_shards')
	event.create('misc_mats/refined_vanilla')

	event.create('prop_foods/cookie').texture('minecraft:item/cookie')

	event.create('magnet/copper').unstackable()
	event.create('magnet/colored_steel').unstackable().rarity('uncommon')
	event.create('magnet/hdpe_offline').unstackable().rarity('common')
	event.create('magnet/hdpe').unstackable().rarity('rare')
	event.create('magnet/polonium').unstackable().rarity('epic')

	event.create('gravedigger', 'shovel').displayName('Gravedigger Shovel').rarity('uncommon')
		.tier('castIron').attackDamageBaseline(0.5 - 1).speedBaseline(0.9 - 4)

	event.create('sanitizer_bottle').unstackable().rarity('uncommon')
		.barWidth(itemstack => Math.floor((itemstack?.nbt?.CustomModelData || 0) / (1000 / 13))) // Full bar is 13
		.barColor(itemstack => Color.AQUA)
		.use((level, player, hand) => true)
		
	event.create('dust_mop').unstackable()
		.useAnimation('bow').useDuration(itemstack => 40)
		.barWidth(itemstack => Math.floor((itemstack?.nbt?.CustomModelData || 0) / (1000 / 13)))
		.barColor(itemstack => Color.BLUE)
		.use((level, player, hand) => global.mopUse(level, player, hand))
		.finishUsing((itemstack, level, player) => global.mopFinishUsing(itemstack, level, player))

	event.create('raw_cookie').food(food => { food.hunger(1).saturation(0) })//.eaten(ctx => {ctx.player.tell(Text.gold('Yummy Yummy!'))})})
	event.create('silver_carrot').food(food => { food.hunger(1).saturation(0).alwaysEdible() })//.eaten(ctx => {ctx.player.tell(Text.gold('Silver works - Zombie - not today!'))})})
	event.create('silver_apple').food(food => { food.hunger(1).saturation(0).alwaysEdible() })//.eaten(ctx => {ctx.player.tell(Text.gold('Silver works - Zombie - not today!'))})})
	event.create('raw_pancake').food(food => { food.hunger(1).saturation(0) })//.eaten(ctx => {ctx.player.tell(Text.gold('Mniaam Miaammm!'))})})
	event.create('pancake').food(food => { food.hunger(3).saturation(0.6) })//.eaten(ctx => {ctx.player.tell(Text.gold('Mniaam Miaammm!'))})})
	event.create('boiled_grass').food(food => { food.hunger(1).saturation(0.25) })//.eaten(ctx => {ctx.player.tell(Text.gold('hmmm boiled grass? Not Bad!'))})})
	event.create('shark_meat').displayName('Raw Shark Meat').food(food => { food.hunger(3).saturation(0.5) })//.eaten(ctx => {ctx.player.tell(Text.gold('Bleee Raw Shark!'))})})
	event.create('shark_cooked_meat').displayName('Cooked Shark Meat').food(food => { food.hunger(7).saturation(1.0) })//.eaten(ctx => {ctx.player.tell(Text.gold('Mniaam Cooked Shark!'))})})
	event.create('crumbled_rock')
	event.create('andesite_rock_powder')
	event.create('cut_tea_leaves')
	event.create('dry_tea_leaves')
	event.create('cut_cattail')
	event.create('tree_seed_paste')
	event.create('seed_paste')
	event.create('primitive_glass_pane')
	event.create('raw_platinum')
	event.create('seed_biomass')
	event.create('vulcanized_rubber')
	event.create('pile_carbon_waste').displayName('Pile of Carbon Waste')
	event.create('pile_sulfur_waste').displayName('Pile of Sulfur Waste')
	event.create('sulfur_waste').displayName('Dirty Sulfur Waste Dust')
	event.create('nutrimix').displayName('Nutritional Mix')
	event.create('feed_hay').displayName('Hay Feed')
	event.create('feed_meat').displayName('Meat Feed')
	event.create('feed_seed').displayName('Seed Feed')
	event.create('feed_vege').displayName('Vegetable Feed')
	event.create('feed_fruit').displayName('Fruit Feed')
	event.create('slot_pocket').displayName('Inventory Slot Pocket')
	event.create('medical_white_powder').displayName('Medicinal White Powder')
	event.create('medical_red_powder').displayName('Medicinal Red Powder')
	event.create('medical_green_powder').displayName('Medicinal Green Powder')
	//event.create('chisel_stone_head')			.displayName('Stone Bit Chisel Head')
	event.create('chisel_iron_head').displayName('Wrought Iron Bit Chisel Head')
	event.create('chisel_rose_gold_head').displayName('Rose Gold Bit Chisel Head')
	event.create('chisel_blue_steel_head').displayName('Blue Steel Bit Chisel Head')
	event.create('chisel_compressed_iron_head').displayName('Compressed Iron Bit Chisel Head')
	event.create('spool_wire').displayName('Spool')
	event.create('sq_tieless').displayName('Incomplete Tieless Train Track')
	event.create('sq_ins_copp').displayName('Incomplete Insulated LV Wire Coil')
	event.create('sq_ins_elec').displayName('Incomplete Insulated MV Wire Coil')
	event.create('sq_spool_copper').displayName('Incomplete Copper Spool')
	event.create('sq_spool_gold').displayName('Incomplete Gold Spool')
	event.create('sq_wire_copp').displayName('Incomplete LV Wire Coil')
	event.create('sq_wire_elec').displayName('Incomplete MV Wire Coil')
	event.create('sq_wire_reds').displayName('Incomplete Redstone Wire Coil')
	event.create('sq_wire_steel').displayName('Incomplete Steel Cable Coil')
	event.create('sq_fluidpipecr').displayName('Incomplete Fluid Pipe')
	event.create('sq_fluidpipeie').displayName('Incomplete Fluid Pipe')
	event.create('sq_presstube').displayName('Incomplete Pressure Tube')
	event.create('sq_embpipe').displayName('Incomplete Embedded Pipe')
	event.create('stack_treated_wood').displayName('Stack of Treated Wood')
	event.create('big_stack_treated_wood').displayName('Large Stack of Treated Wood')
	event.create('press_head').displayName('Mechanical Press Head')
	event.create('hardened_press_head').displayName('Blue Steel Hardened Press Head').unstackable()
	event.create('hardened_press_head_red').displayName('Red Steel Hardened Press Head').unstackable()
	event.create('canoe').displayName('Canoe - First Boat')
	event.create('un_casing').displayName('Incomplete Technic Block')
	event.create('un_sheet').displayName('Incomplete Technic Item')
	event.create('sugar_mass').displayName('Raw Sugar Mass')
	event.create('hemp_stack').displayName('Stack of Hemp Fibers')
	event.create('compressed_double_ingot').displayName('Compressed Iron Double Ingot')
	event.create('compressed_sheet').displayName('Compressed Iron Sheet')
	event.create('compressed_double_sheet').displayName('Compressed Iron Double Sheet')
	event.create('compressed_rod').displayName('Compressed Iron Rod')
	event.create('compressed_mesh').displayName('Compressed Iron Mesh')
	event.create('compressed_wire').displayName('Compressed Iron Wire')
	event.create('hide_tanned_s').displayName('Small Tanned Hide')
	event.create('hide_tanned_m').displayName('Medium Tanned Hide')
	event.create('hide_tanned_l').displayName('Large Tanned Hide')
	event.create('hide_oiled_s').displayName('Small Oiled Hide')
	event.create('hide_oiled_m').displayName('Medium Oiled Hide')
	event.create('hide_oiled_l').displayName('Large Oiled Hide')
	event.create('hide_finish_s').displayName('Small Leather')
	event.create('hide_finish_m').displayName('Medium Leather')
	event.create('hide_finish_l').displayName('Large Leather')
	event.create('medical_paste').displayName('Medicinal Herb Paste')
	event.create('magic_crystal').displayName('Magic Twilight Crystal')
	event.create('fuel_component').displayName('Rocket Fuel Catalyst')
	event.create('img_arcfurnace').displayName('img_arcfurnace')
	event.create('img_cokker').displayName('img_cokker')
	event.create('img_crusher').displayName('img_crusher')
	event.create('img_derrik').displayName('img_derrik')
	event.create('img_destillation').displayName('img_destillation')
	event.create('img_diesel').displayName('img_diesel')
	event.create('img_excavator').displayName('img_excavator')
	event.create('img_metalpress').displayName('img_metalpress')
	event.create('img_oiltank').displayName('img_oiltank')
	event.create('img_pumpjack').displayName('img_pumpjack')
	event.create('img_refinery').displayName('img_refinery')
	event.create('img_sawmill').displayName('img_sawmill')
	event.create('img_squezzer').displayName('img_squezzer')
	event.create('img_ores').displayName('img_ores')
	event.create('img_wiki').displayName('img_wiki')
	event.create('img_book').displayName('img_book')
})

// Gravedigger shovel
onEvent('item.registry.tool_tiers', event => {
	// BRONZE =         (2, 1300, 7.3, 4.0, 13)
	// BISMUTH_BRONZE = (2, 1200, 6.65, 4.0, 10)
	// BLACK_BRONZE =   (2, 1460, 6.0, 4.25, 10)
	// WROUGHT_IRON =   (3, 2200, 8.0, 4.75, 12)
	event.add('castIron', tier => {
		tier.level = 2
		tier.uses = 800
		tier.speed = 4.5
		tier.attackDamageBonus = 4.5
		tier.enchantmentValue = 8
		tier.repairIngredient = '#forge:ingots/cast_iron'
	})
})


// Dust mop
const $ClipContext = java('net.minecraft.world.level.ClipContext')
const BLOCK_VISUAL = $ClipContext.Block.VISUAL
const FLUID_ANY = $ClipContext.Fluid.ANY

const rayTraceNonSolid = (player, level) => {
	if (level.minecraftLevel.isClientSide()) return { block: null, id: null }

	let mcPlayer = player.minecraftPlayer

	let eyePos = mcPlayer.getEyePosition(0)
	let lookVec = mcPlayer.getLookAngle()

	let reach = player.reachDistance || 5.0

	let hitResult = level.minecraftLevel.clip(
		new $ClipContext(
			eyePos,
			eyePos.add(lookVec.x() * reach, lookVec.y() * reach, lookVec.z() * reach),
			BLOCK_VISUAL,
			FLUID_ANY,
			mcPlayer
		)
	)
	let block = level.getBlock(hitResult.getBlockPos())

	return {
		block: block,
		blockPos: hitResult.getBlockPos()
	}
}

global.mopUse = (level, player, hand) => {
	if (level.minecraftLevel.isClientSide()) return false

	let mop = player.minecraftPlayer.getItemInHand(hand)

	// Get the targeted block
	const { block } = rayTraceNonSolid(player, level)
	if (['minecraft:water', 'tfc:fluid/river_water'].includes(block.id)) {
		if ((mop?.tag?.CustomModelData || 0) < 1000) {
			mop.getOrCreateTag().putInt('CustomModelData', 1000)
			player.playSound('minecraft:item.bottle.fill', 1, 1)
			player.setStatusMessage(`${mop.tag.CustomModelData}mb of water remaining`)
			return false // Don't do the draw animation
		}
	}


	// Print some helpers for newer players, not sure if those will be very useful
	if (block.id == 'adpother:carbon') player.setStatusMessage('This is Carbon! mops only work on dust.')
	if (block.id == 'adpother:sulfur') player.setStatusMessage('This is Sulfur! mops only work on dust.')

	if (block.id != 'adpother:dust') return false
	
	// Check that the mop has enough water
	if ((mop?.tag?.CustomModelData || 0) < 100) {
		player.setStatusMessage('Not enough water!')
		return false
	}
	return true
}

global.mopFinishUsing = (itemstack, level, player) => {
	if (level.minecraftLevel.isClientSide()) return itemstack

	// Confirm that we are discharging at a dust block
	const { block, blockPos } = rayTraceNonSolid(player, level)
	if (block.id != 'adpother:dust') return itemstack
	// Juuuust in case, verify that there is enough water for a second time
	if ((itemstack?.nbt?.CustomModelData || 0) < 100) {
		player.setStatusMessage('Not enough water!')
		return itemstack
	}

	// Remove the dust block
	level.minecraftLevel.destroyBlock(blockPos, false)
	itemstack.nbt.CustomModelData -= 100
	player.playSound('minecraft:item.bottle.empty', 1, 1)
	player.setStatusMessage(`${itemstack.nbt.CustomModelData}mb of water remaining`)

	return itemstack
}
