#version 150
uniform sampler2D DiffuseSampler;
uniform vec2 FocalUV;
uniform int Samples;
uniform float Strength;

in vec2 texCoord;
out vec4 fragColor;

void main() {
    vec2 dir = FocalUV - texCoord;
    float dist = length(dir);

    if (dist < 0.0001) {
        fragColor = texture(DiffuseSampler, texCoord);
        return;
    }

    dir /= dist;

    vec4 result = vec4(0.0);
    float totalWeight = 0.0;
    int s = max(1, Samples);

    for (int i = 0; i < s; i++) {
        float t = (s == 1) ? 0.0 : (float(i) / float(s - 1));
        float weight = 1.0 - abs(t - 0.5) * 2.0;
        float offset = t * Strength * dist;
        vec2 sampleCoord = clamp(texCoord + dir * offset, vec2(0.0), vec2(1.0));
        result += texture(DiffuseSampler, sampleCoord) * weight;
        totalWeight += weight;
    }

    if (totalWeight > 0.0) result /= totalWeight;
    fragColor = result;
}