#version 150

uniform sampler2D DiffuseSampler;
uniform sampler2D BlurSampler;
uniform float Threshold;
uniform float ThresholdLerp;
uniform int Levels;
uniform float GlowIntensity;

in vec2 texCoord;
out vec4 fragColor;

float posterize(float value, int levels) {
    if (levels <= 1) return value;
    float step = 1.0 / float(levels);
    return floor(value / step) * step;
}

void main() {
    vec3 original = texture(DiffuseSampler, texCoord).rgb;
    vec4 blur = texture(BlurSampler, texCoord);
    float luminance = dot(blur.rgb, vec3(0.299, 0.587, 0.114));
    float posterized = posterize(luminance, Levels);
    fragColor = vec4(posterized, posterized, posterized, 1.0);
}