#version 150

uniform sampler2D DiffuseSampler;
uniform vec2 ScreenSize;
uniform float Time;
uniform vec2 FocalUV;
uniform float Scale;
uniform float Intensity;
uniform vec3 ColorFilter;


in vec2 texCoord;
out vec4 fragColor;

float hash(vec2 p) {
    return fract(sin(dot(p, vec2(127.1, 311.7))) * 43758.5453); // <-- Modificar esta mierda
}

float noise(vec2 p) {
    vec2 i = floor(p);
    vec2 f = fract(p);
    float a = hash(i);
    float b = hash(i + vec2(1.0, 0.0));
    float c = hash(i + vec2(0.0, 1.0));
    float d = hash(i + vec2(1.0, 1.0));
    vec2 u = f * f * (3.0 - 2.0 * f);
    return mix(mix(a, b, u.x), mix(c, d, u.x), u.y);
}

void main() {
    vec4 baseColor = texture(DiffuseSampler, texCoord);
    vec2 uv = texCoord;
    float n = noise((uv - FocalUV) * Scale + Time * 0.1);
    vec3 noisyColor = vec3(n) * ColorFilter * Intensity;
    fragColor = vec4(baseColor.rgb + noisyColor, baseColor.a);
}