#version 150

uniform sampler2D DiffuseSampler;
uniform float SaturationIntensity;

in vec2 texCoord;
out vec4 fragColor;

void main() {
    vec4 base = texture(DiffuseSampler, texCoord);
    float luminance = dot(base.rgb, vec3(0.299, 0.587, 0.114));
    vec3 saturated = mix(base.rgb, vec3(1.0), SaturationIntensity);
    fragColor = vec4(saturated, base.a);
}
