#version 150

uniform sampler2D DiffuseSampler;
uniform vec2 OutSize;
uniform vec2 ImpactPos;
uniform float Intensity;
uniform float Time;

in vec2 texCoord;
out vec4 fragColor;

void main() {
    vec2 dir = texCoord - ImpactPos;
    float dist = length(dir);
    if (Intensity > 0.01 && dist < 0.3) {
        vec4 sum = vec4(0.0);
        const int SAMPLES = 6;

        for(int i = 0; i < SAMPLES; i++) {
            float t = float(i) / float(SAMPLES - 1);
            vec2 sampleCoord = texCoord - dir * t * 0.08 * Intensity;
            sum += texture(DiffuseSampler, sampleCoord);
        }

        fragColor = sum / float(SAMPLES);
    } else {
        fragColor = texture(DiffuseSampler, texCoord);
    }
}