#version 150
uniform sampler2D DiffuseSampler;
uniform float Time;
uniform float Intensity;
uniform vec3 ColorFilter;

in vec2 texCoord;
out vec4 fragColor;

float hash(vec2 p){ return fract(sin(dot(p, vec2(127.1,311.7))) * 43758.5453); }

float noise(vec2 p){
    vec2 i = floor(p);
    vec2 f = fract(p);
    float a = hash(i);
    float b = hash(i + vec2(1.0,0.0));
    float c = hash(i + vec2(0.0,1.0));
    float d = hash(i + vec2(1.0,1.0));
    vec2 u = f*f*(3.0-2.0*f);
    return mix(mix(a,b,u.x), mix(c,d,u.x), u.y);
}

void main(){
    vec4 base = texture(DiffuseSampler, texCoord);
    float n = noise(texCoord*50.0 + Time*3.0);

    // Posterizar para 4 niveles
    vec3 col = floor(base.rgb*4.0)/4.0;
    col += n*0.2*Intensity;
    col *= mix(vec3(1.0), ColorFilter, 0.6*Intensity);
    fragColor = vec4(clamp(col,0.0,1.0), base.a);
}
