/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.decoration.Decoration;
import net.countered.settlementroads.features.decoration.DistanceSignDecoration;
import net.countered.settlementroads.features.decoration.FenceWaypointDecoration;
import net.countered.settlementroads.features.decoration.LamppostDecoration;
import net.countered.settlementroads.features.decoration.RoadStructures;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.attachments.WorldDataAttachment;
import net.minecraft.class_1923;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6796;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadFeature
extends class_3031<RoadFeatureConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"settlement-roads");
    public static final Set<class_2248> dontPlaceHere = new HashSet<class_2248>();
    public static int chunksForLocatingCounter;
    public static final class_5321<class_6796> ROAD_FEATURE_PLACED_KEY;
    public static final class_5321<class_2975<?, ?>> ROAD_FEATURE_KEY;
    public static final class_3031<RoadFeatureConfig> ROAD_FEATURE;

    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<RoadFeatureConfig> context) {
        if (RoadPathCalculator.heightCache.size() > 100000) {
            RoadPathCalculator.heightCache.clear();
        }
        class_3218 serverWorld = context.method_33652().method_8410();
        class_5281 structureWorldAccess = context.method_33652();
        Records.StructureLocationData structureLocationData = (Records.StructureLocationData)serverWorld.getAttached(WorldDataAttachment.STRUCTURE_LOCATIONS);
        if (structureLocationData == null) {
            return false;
        }
        List<class_2338> villageLocations = structureLocationData.structureLocations();
        this.tryFindNewStructureConnection(villageLocations, serverWorld);
        HashSet<Decoration> roadDecorationCache = new HashSet<Decoration>();
        this.runRoadLogic(structureWorldAccess, context, roadDecorationCache);
        RoadStructures.tryPlaceDecorations(roadDecorationCache);
        return true;
    }

    private void tryFindNewStructureConnection(List<class_2338> villageLocations, class_3218 serverWorld) {
        if ((villageLocations == null || villageLocations.size() < ModConfig.maxLocatingCount) && ++chunksForLocatingCounter > 300) {
            List connectionList = (List)serverWorld.getAttached(WorldDataAttachment.CONNECTED_STRUCTURES);
            serverWorld.method_8503().execute(() -> StructureConnector.cacheNewConnection(serverWorld, true));
            chunksForLocatingCounter = 1;
        }
    }

    private void runRoadLogic(class_5281 structureWorldAccess, class_5821<RoadFeatureConfig> context, Set<Decoration> roadDecorationPlacementPositions) {
        int averagingRadius = ModConfig.averagingRadius;
        List roadDataList = (List)structureWorldAccess.method_8410().getAttached(WorldDataAttachment.ROAD_DATA_LIST);
        if (roadDataList == null) {
            return;
        }
        class_1923 currentChunkPos = new class_1923(context.method_33655());
        HashSet<class_2338> posAlreadyContainsSegment = new HashSet<class_2338>();
        for (Records.RoadData data : roadDataList) {
            int roadType = data.roadType();
            List<class_2680> materials = data.materials();
            List<Records.RoadSegmentPlacement> segmentList = data.roadSegmentList();
            List<class_2338> middlePositions = segmentList.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
            int segmentIndex = 0;
            for (int i = 2; i < segmentList.size() - 2; ++i) {
                class_1923 middleChunkPos;
                if (posAlreadyContainsSegment.contains(middlePositions.get(i))) continue;
                Records.RoadSegmentPlacement segment = segmentList.get(i);
                class_2338 segmentMiddlePos = segment.middlePos();
                if (++segmentIndex < 60 || segmentIndex > segmentList.size() - 60 || !(middleChunkPos = new class_1923(segmentMiddlePos)).equals((Object)currentChunkPos)) continue;
                class_2338 prevPos = middlePositions.get(i - 2);
                class_2338 nextPos = middlePositions.get(i + 2);
                ArrayList<Double> heights = new ArrayList<Double>();
                for (int j = i - averagingRadius; j <= i + averagingRadius; ++j) {
                    if (j < 0 || j >= middlePositions.size()) continue;
                    class_2338 samplePos = middlePositions.get(j);
                    double y = structureWorldAccess.method_8624(class_2902.class_2903.field_13194, samplePos.method_10263(), samplePos.method_10260());
                    heights.add(y);
                }
                int averageY = (int)Math.round(heights.stream().mapToDouble(Double::doubleValue).average().orElse(segmentMiddlePos.method_10264()));
                class_2338 averagedPos = new class_2338(segmentMiddlePos.method_10263(), averageY, segmentMiddlePos.method_10260());
                class_5819 random = context.method_33654();
                if (!ModConfig.placeWaypoints) {
                    for (class_2338 widthBlock : segment.positions()) {
                        class_2338 correctedYPos = new class_2338(widthBlock.method_10263(), averageY, widthBlock.method_10260());
                        this.placeOnSurface(structureWorldAccess, correctedYPos, materials, roadType, random);
                    }
                }
                this.addDecoration(structureWorldAccess, roadDecorationPlacementPositions, averagedPos, segmentIndex, nextPos, prevPos, middlePositions, roadType, random);
                posAlreadyContainsSegment.add(segmentMiddlePos);
            }
        }
    }

    private void addDecoration(class_5281 structureWorldAccess, Set<Decoration> roadDecorationPlacementPositions, class_2338 placePos, int segmentIndex, class_2338 nextPos, class_2338 prevPos, List<class_2338> middleBlockPositions, int roadType, class_5819 random) {
        boolean isEnd;
        int dz;
        class_2338 surfacePos = placePos.method_33096(structureWorldAccess.method_8624(class_2902.class_2903.field_13194, placePos.method_10263(), placePos.method_10260()));
        class_2680 blockStateAtPos = structureWorldAccess.method_8320(surfacePos.method_10074());
        if (blockStateAtPos.equals(class_2246.field_10382.method_9564()) && segmentIndex % ModConfig.distanceBetweenBuoys == 0) {
            RoadStructures.placeBuoy(structureWorldAccess, surfacePos);
        }
        if (ModConfig.placeWaypoints) {
            if (segmentIndex % 25 == 0) {
                roadDecorationPlacementPositions.add(new FenceWaypointDecoration(surfacePos, structureWorldAccess));
            }
            return;
        }
        int dx = nextPos.method_10263() - prevPos.method_10263();
        double length = Math.sqrt(dx * dx + (dz = nextPos.method_10260() - prevPos.method_10260()) * dz);
        int normDx = length != 0.0 ? (int)Math.round((double)dx / length) : 0;
        int normDz = length != 0.0 ? (int)Math.round((double)dz / length) : 0;
        class_2382 directionVector = new class_2382(normDx, 0, normDz);
        class_2382 orthogonalVector = new class_2382(-directionVector.method_10260(), 0, directionVector.method_10263());
        boolean bl = isEnd = segmentIndex != middleBlockPositions.size() - 65;
        if (segmentIndex == 65 || segmentIndex == middleBlockPositions.size() - 65) {
            class_2338 shiftedPos = isEnd ? placePos.method_10081(orthogonalVector.method_35862(2)) : placePos.method_10059(orthogonalVector.method_35862(2));
            roadDecorationPlacementPositions.add(new DistanceSignDecoration(shiftedPos, orthogonalVector, structureWorldAccess, isEnd, String.valueOf(middleBlockPositions.size())));
        } else if (segmentIndex % 59 == 0) {
            boolean leftRoadSide = random.method_43056();
            class_2338 shiftedPos = leftRoadSide ? placePos.method_10081(orthogonalVector.method_35862(2)) : placePos.method_10059(orthogonalVector.method_35862(2));
            if (Math.abs((shiftedPos = shiftedPos.method_33096(structureWorldAccess.method_8624(class_2902.class_2903.field_13194, shiftedPos.method_10263(), shiftedPos.method_10260()))).method_10264() - placePos.method_10264()) > 1) {
                return;
            }
            if (roadType == 0) {
                roadDecorationPlacementPositions.add(new LamppostDecoration(shiftedPos, orthogonalVector, structureWorldAccess, leftRoadSide));
            } else {
                roadDecorationPlacementPositions.add(new FenceWaypointDecoration(shiftedPos, structureWorldAccess));
            }
        }
    }

    private void placeOnSurface(class_5281 structureWorldAccess, class_2338 placePos, List<class_2680> material, int natural, class_5819 random) {
        double naturalBlockChance = 0.5;
        class_2338 surfacePos = placePos;
        if (natural == 1 || ModConfig.averagingRadius == 0) {
            surfacePos = structureWorldAccess.method_8598(class_2902.class_2903.field_13194, placePos);
        }
        class_2680 blockStateAtPos = structureWorldAccess.method_8320(structureWorldAccess.method_8598(class_2902.class_2903.field_13194, surfacePos).method_10074());
        if (natural == 0 || random.method_43058() < naturalBlockChance) {
            this.placeRoadBlock(structureWorldAccess, blockStateAtPos, surfacePos, material, random);
        }
    }

    private void placeRoadBlock(class_5281 structureWorldAccess, class_2680 blockStateAtPos, class_2338 surfacePos, List<class_2680> materials, class_5819 deterministicRandom) {
        class_2680 blockStateUp;
        if (!this.placeAllowedCheck(blockStateAtPos.method_26204()) || !structureWorldAccess.method_8320(surfacePos.method_10074()).method_26225() && !structureWorldAccess.method_8320(surfacePos.method_10087(2)).method_26225()) {
            return;
        }
        class_2680 material = materials.get(deterministicRandom.method_43048(materials.size()));
        this.method_13153((class_1945)structureWorldAccess, surfacePos.method_10074(), material);
        for (int i = 0; !(i >= 3 || (blockStateUp = structureWorldAccess.method_8320(surfacePos.method_10086(i))).method_26204().equals(class_2246.field_10124) || blockStateUp.method_26164(class_3481.field_15475) || blockStateUp.method_26164(class_3481.field_16584)); ++i) {
            this.method_13153((class_1945)structureWorldAccess, surfacePos.method_10086(i), class_2246.field_10124.method_9564());
        }
        class_2338 belowPos1 = surfacePos.method_10087(2);
        class_2680 belowState1 = structureWorldAccess.method_8320(belowPos1);
        if (belowState1.method_26204().equals(class_2246.field_10219)) {
            this.method_13153((class_1945)structureWorldAccess, belowPos1, class_2246.field_10566.method_9564());
        }
    }

    private boolean placeAllowedCheck(class_2248 blockToCheck) {
        return !dontPlaceHere.contains(blockToCheck) && !blockToCheck.method_9564().method_26164(class_3481.field_15503) && !blockToCheck.method_9564().method_26164(class_3481.field_15475) && !blockToCheck.method_9564().method_26164(class_3481.field_15496) && !blockToCheck.method_9564().method_26164(class_3481.field_17619) && !blockToCheck.method_9564().method_26164(class_3481.field_15471);
    }

    static {
        dontPlaceHere.add(class_2246.field_10225);
        dontPlaceHere.add(class_2246.field_10295);
        dontPlaceHere.add(class_2246.field_10384);
        dontPlaceHere.add(class_2246.field_10238);
        dontPlaceHere.add(class_2246.field_37546);
        chunksForLocatingCounter = 1;
        ROAD_FEATURE_PLACED_KEY = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_43902((String)"settlement-roads", (String)"road_feature_placed"));
        ROAD_FEATURE_KEY = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_43902((String)"settlement-roads", (String)"road_feature"));
        ROAD_FEATURE = new RoadFeature(RoadFeatureConfig.CODEC);
    }
}

