/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.dynamicpack;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;

public class ServerDynamicResourcesHandler
extends DynServerResourcesGenerator {
    private static ServerDynamicResourcesHandler INSTANCE;

    public static ServerDynamicResourcesHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ServerDynamicResourcesHandler();
        }
        return INSTANCE;
    }

    public ServerDynamicResourcesHandler() {
        super(new DynamicDataPack(EveryCompat.res("generated_pack")));
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"minecraft"});
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"forge"});
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"c"});
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"everycomp"});
        if (PlatHelper.isModLoaded((String)"lolmcv")) {
            ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"lieonstudio"});
            ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"quad"});
        }
    }

    public Logger getLogger() {
        return EveryCompat.LOGGER;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        if (!ECConfigs.GENERATE_DYNAMIC_SERVER.get().booleanValue()) {
            return;
        }
        ((DynamicDataPack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || ECConfigs.DEBUG_RESOURCES.get() != false);
        ArrayList tasks = new ArrayList();
        EveryCompat.forAllModules(m -> m.addDynamicServerResources(tasks::add));
        int minBatches = Runtime.getRuntime().availableProcessors();
        int maxBatches = tasks.size() / Runtime.getRuntime().availableProcessors();
        int batchSize = Math.max(minBatches, maxBatches);
        EveryCompat.LOGGER.info("Every Compat is starting dynamic server resources generation tasks: {} in batches of {}", (Object)tasks.size(), (Object)batchSize);
        for (int i = 0; i < tasks.size(); i += batchSize) {
            int end = Math.min(i + batchSize, tasks.size());
            List subList = tasks.subList(i, end);
            executor.accept((resourceManager, resourceSink) -> {
                for (ResourceGenTask task : subList) {
                    task.accept(resourceManager, resourceSink);
                }
            });
        }
        if (ECConfigs.GENERATE_BLOCKTYPE_TAGS.get().booleanValue()) {
            executor.accept((resourceManager, resourceSink) -> {
                for (BlockTypeRegistry r : BlockSetAPI.getRegistries()) {
                    String typeName = r.typeName();
                    for (BlockType blockType : r.getValues()) {
                        ResourceLocation tagId = blockType.getId().m_246208_(typeName + "/");
                        SimpleTagBuilder itemTag = SimpleTagBuilder.of((ResourceLocation)tagId);
                        SimpleTagBuilder blockTag = SimpleTagBuilder.of((ResourceLocation)tagId);
                        boolean isItemAddedToTag = false;
                        boolean isBlockAddedToTag = false;
                        for (Map.Entry entrySet : blockType.getChildren()) {
                            Item item;
                            String key = (String)entrySet.getKey();
                            if (key.equals("diagonalfences:fence")) continue;
                            Block block = blockType.getBlockOfThis(key);
                            if (block != null) {
                                isBlockAddedToTag = true;
                                blockTag.addEntry((Object)block);
                            }
                            if ((item = blockType.getItemOfThis(key)) == null) continue;
                            isItemAddedToTag = true;
                            itemTag.addEntry((Object)item);
                        }
                        if (isBlockAddedToTag) {
                            resourceSink.addTag(blockTag, Registries.f_256747_);
                        }
                        if (!isItemAddedToTag) continue;
                        resourceSink.addTag(itemTag, Registries.f_256913_);
                    }
                }
            });
        }
    }
}

