/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.base;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistryV3;
import dev.onyxstudios.cca.internal.base.asm.CcaBootstrap;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_2960;

public final class ComponentRegistryImpl
implements ComponentRegistryV3 {
    public static final ComponentRegistryImpl INSTANCE = new ComponentRegistryImpl();
    private final Map<class_2960, ComponentKey<?>> keys = new HashMap();

    public synchronized <T extends Component> ComponentKey<T> getOrCreate(class_2960 componentId, Class<T> componentClass) {
        Preconditions.checkArgument((boolean)Component.class.isAssignableFrom(componentClass), (Object)("Component interface must extend " + Component.class.getCanonicalName()));
        ComponentKey<?> existing = this.get(componentId);
        if (existing != null) {
            if (existing.getComponentClass() != componentClass) {
                throw new IllegalStateException("Registered component " + componentId + " twice with 2 different classes: " + existing.getComponentClass() + ", " + componentClass);
            }
            return existing;
        }
        Class<? extends ComponentKey<?>> generated = CcaBootstrap.INSTANCE.getGeneratedComponentTypeClass(componentId);
        if (generated == null) {
            throw new IllegalStateException(componentId + " was not registered through mod metadata or plugin");
        }
        ComponentKey<T> registered = this.instantiateStaticType(generated, componentId, componentClass);
        this.keys.put(componentId, registered);
        return registered;
    }

    private <T extends Component> ComponentKey<T> instantiateStaticType(Class<? extends ComponentKey<?>> generated, class_2960 componentId, Class<T> componentClass) {
        try {
            ComponentKey<?> ret = generated.getConstructor(class_2960.class, Class.class).newInstance(componentId, componentClass);
            return ret;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to create statically declared component type", e);
        }
    }

    @Override
    @Nullable
    public ComponentKey<?> get(class_2960 id) {
        return this.keys.get(id);
    }

    @Override
    public Stream<ComponentKey<?>> stream() {
        return new HashSet(this.keys.values()).stream();
    }

    @VisibleForTesting
    void clear(class_2960 id) {
        this.keys.remove(id);
    }
}

