/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.modernworldcreation.util;

import de.keksuccino.konkrete.config.Config;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractOptions {

    public static class UnsupportedOptionTypeException
    extends RuntimeException {
        public UnsupportedOptionTypeException() {
        }

        public UnsupportedOptionTypeException(String msg) {
            super(msg);
        }
    }

    public static class Option<T> {
        protected final Config config;
        protected final String key;
        protected final T defaultValue;
        protected final String category;

        public Option(@NotNull Config config, @NotNull String key, @NotNull T defaultValue, @NotNull String category) {
            this.config = Objects.requireNonNull(config);
            this.key = Objects.requireNonNull(key);
            this.defaultValue = Objects.requireNonNull(defaultValue);
            this.category = Objects.requireNonNull(category);
            this.register();
        }

        protected void register() {
            boolean unsupported = false;
            try {
                if (this.defaultValue instanceof Integer) {
                    this.config.registerValue(this.key, Integer.valueOf((Integer)this.defaultValue), this.category);
                } else if (this.defaultValue instanceof Double) {
                    this.config.registerValue(this.key, Double.valueOf((Double)this.defaultValue), this.category);
                } else if (this.defaultValue instanceof Long) {
                    this.config.registerValue(this.key, Long.valueOf((Long)this.defaultValue), this.category);
                } else if (this.defaultValue instanceof Float) {
                    this.config.registerValue(this.key, Float.valueOf(((Float)this.defaultValue).floatValue()), this.category);
                } else if (this.defaultValue instanceof Boolean) {
                    this.config.registerValue(this.key, Boolean.valueOf((Boolean)this.defaultValue), this.category);
                } else if (this.defaultValue instanceof String) {
                    this.config.registerValue(this.key, (String)this.defaultValue, this.category);
                } else {
                    unsupported = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (unsupported) {
                throw new UnsupportedOptionTypeException("Tried to register Option with unsupported type: " + this.key + " (" + this.defaultValue.getClass().getName() + ")");
            }
        }

        @NotNull
        public T getValue() {
            return (T)this.config.getOrDefault(this.key, this.defaultValue);
        }

        public Option<T> setValue(T value) {
            try {
                if (value == null) {
                    value = this.getDefaultValue();
                }
                if (value instanceof Integer) {
                    this.config.setValue(this.key, Integer.valueOf((Integer)value));
                } else if (value instanceof Double) {
                    this.config.setValue(this.key, Double.valueOf((Double)value));
                } else if (value instanceof Long) {
                    this.config.setValue(this.key, Long.valueOf((Long)value));
                } else if (value instanceof Float) {
                    this.config.setValue(this.key, Float.valueOf(((Float)value).floatValue()));
                } else if (value instanceof Boolean) {
                    this.config.setValue(this.key, Boolean.valueOf((Boolean)value));
                } else if (value instanceof String) {
                    this.config.setValue(this.key, (String)value);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return this;
        }

        public Option<T> resetToDefault() {
            this.setValue(null);
            return this;
        }

        @NotNull
        public T getDefaultValue() {
            return this.defaultValue;
        }

        @NotNull
        public String getKey() {
            return this.key;
        }
    }
}

