/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.modernworldcreation;

import de.keksuccino.modernworldcreation.ModernWorldCreation;
import de.keksuccino.modernworldcreation.mixin.mixins.common.client.IMixinCreateWorldScreen;
import de.keksuccino.modernworldcreation.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.modernworldcreation.mixin.mixins.common.client.IMixinTabNavigationBar;
import de.keksuccino.modernworldcreation.util.fancymenu.FMAccess;
import de.keksuccino.modernworldcreation.util.fancymenu.FMUtils;
import de.keksuccino.modernworldcreation.util.rendering.gui.ExtendedTabManager;
import de.keksuccino.modernworldcreation.util.rendering.gui.widgets.ArrowButton;
import de.keksuccino.modernworldcreation.util.rendering.gui.widgets.ToggleModeButton;
import de.keksuccino.modernworldcreation.util.rendering.screens.ExtendedCreateWorldScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModernWorldCreationGameTab
extends GridLayoutTab {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation BUTTON_TEXTURE_SURVIVAL = new ResourceLocation("modernworldcreation", "textures/gamemodes/background_survival.png");
    private static final ResourceLocation BUTTON_TEXTURE_CREATIVE = new ResourceLocation("modernworldcreation", "textures/gamemodes/background_creative.png");
    private static final ResourceLocation BUTTON_TEXTURE_HARDCORE = new ResourceLocation("modernworldcreation", "textures/gamemodes/background_hardcore.png");
    private static final Component SURVIVAL_LABEL = Component.m_237115_((String)"modernworldcreation.gamemodes.survival").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
    private static final Component CREATIVE_LABEL = Component.m_237115_((String)"modernworldcreation.gamemodes.creative").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
    private static final Component HARDCORE_LABEL = Component.m_237115_((String)"modernworldcreation.gamemodes.hardcore").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
    protected static final Component NAME_LABEL = Component.m_237115_((String)"selectWorld.enterName");
    protected static final Component EXPERIMENTS_LABEL = Component.m_237115_((String)"selectWorld.experiments");
    protected static final Component ALLOW_COMMANDS_INFO = Component.m_237115_((String)"selectWorld.allowCommands.info");
    protected static final Component TITLE = Component.m_237115_((String)"createWorld.tab.game.title");
    protected static final Component ALLOW_COMMANDS = Component.m_237115_((String)"selectWorld.allowCommands");
    protected final Font font;
    protected EditBox nameEdit;
    protected ArrowButton arrowLeftButton;
    protected ArrowButton arrowRightButton;
    protected ToggleModeButton gamemodeSurvivalButton;
    protected ToggleModeButton gamemodeCreativeButton;
    protected ToggleModeButton gamemodeHardcoreButton;
    protected CycleButton<Boolean> allowCheatsButton;
    protected CycleButton<Difficulty> difficultyButton;
    protected Button experimentsButton;

    public ModernWorldCreationGameTab(@NotNull CreateWorldScreen parent) {
        super(TITLE);
        this.font = Minecraft.m_91087_().f_91062_;
        WorldCreationUiState uiState = Objects.requireNonNull(((IMixinCreateWorldScreen)parent).get_uiState_ModernWorldCreation());
        GridLayout.RowHelper rowHelper = this.f_267367_.m_267750_(8).m_264606_(1);
        LayoutSettings layoutSettings = rowHelper.m_264551_();
        GridLayout.RowHelper rowHelper2 = new GridLayout().m_267750_(4).m_264606_(1);
        rowHelper2.m_264206_((LayoutElement)new StringWidget(NAME_LABEL, this.font), rowHelper2.m_264551_().m_264400_(1));
        this.nameEdit = (EditBox)rowHelper2.m_264206_((LayoutElement)new EditBox(this.font, 0, 0, 208, 20, (Component)Component.m_237115_((String)"selectWorld.enterName")), rowHelper2.m_264551_().m_264174_(1));
        this.nameEdit.m_94144_(uiState.m_267597_());
        this.nameEdit.m_94151_(arg_0 -> ((WorldCreationUiState)uiState).m_267649_(arg_0));
        uiState.m_267755_(worldCreationUiState -> this.nameEdit.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"selectWorld.targetFolder", (Object[])new Object[]{Component.m_237113_((String)worldCreationUiState.m_275837_()).m_130940_(ChatFormatting.ITALIC)}))));
        ((IMixinScreen)parent).invoke_setInitialFocus_ModernWorldCreation((GuiEventListener)this.nameEdit);
        rowHelper.m_264206_((LayoutElement)rowHelper2.m_267613_(), rowHelper.m_264551_().m_264356_());
        this.difficultyButton = (CycleButton)rowHelper.m_264206_((LayoutElement)CycleButton.m_168894_(Difficulty::m_19033_).m_168961_((Object[])Difficulty.values()).m_168936_(0, 0, 150, 20, (Component)Component.m_237115_((String)"options.difficulty"), (cycleButtonx, difficulty) -> uiState.m_267754_(difficulty)), layoutSettings);
        uiState.m_267755_(worldCreationUiState -> {
            this.difficultyButton.m_168892_((Object)uiState.m_267816_());
            this.difficultyButton.f_93623_ = !uiState.m_267790_();
            this.difficultyButton.m_257544_(Tooltip.m_257550_((Component)uiState.m_267816_().m_267622_()));
        });
        this.allowCheatsButton = (CycleButton)rowHelper.m_264139_((LayoutElement)CycleButton.m_168919_().m_232498_(boolean_ -> Tooltip.m_257550_((Component)ALLOW_COMMANDS_INFO)).m_168936_(0, 0, 150, 20, ALLOW_COMMANDS, (cycleButtonx, boolean_) -> uiState.m_267601_(boolean_.booleanValue())));
        uiState.m_267755_(worldCreationUiState -> {
            this.allowCheatsButton.m_168892_((Object)uiState.m_267823_());
            this.allowCheatsButton.f_93623_ = !uiState.m_267735_() && !uiState.m_267790_();
        });
        if (!SharedConstants.m_183709_().m_132498_()) {
            this.experimentsButton = (Button)rowHelper.m_264139_((LayoutElement)Button.m_253074_((Component)EXPERIMENTS_LABEL, button -> ((IMixinCreateWorldScreen)parent).invoke_openExperimentsScreen_ModernWorldCreation(uiState.m_267573_().f_243842_())).m_252780_(150).m_253136_());
        }
        ((ExtendedCreateWorldScreen)parent).setOnInitBody_ModernWorldCreation(screen -> {
            TabNavigationBar navigationBar = ((IMixinCreateWorldScreen)parent).get_tabNavigationBar_ModernWorldCreation();
            TabManager tabManager = ((IMixinTabNavigationBar)navigationBar).get_tabManager_ModernWorldCreation();
            if (!((ExtendedTabManager)tabManager).hasTabChangeListener_ModernWorldCreation()) {
                ((ExtendedTabManager)tabManager).setTabChangeListener_ModernWorldCreation(tab -> {
                    if (tab != this) {
                        ModernWorldCreationGameTab.removeScreenWidget((Screen)parent, (AbstractWidget)this.gamemodeSurvivalButton);
                        ModernWorldCreationGameTab.removeScreenWidget((Screen)parent, (AbstractWidget)this.gamemodeCreativeButton);
                        ModernWorldCreationGameTab.removeScreenWidget((Screen)parent, (AbstractWidget)this.gamemodeHardcoreButton);
                        ModernWorldCreationGameTab.removeScreenWidget((Screen)parent, (AbstractWidget)this.arrowLeftButton);
                        ModernWorldCreationGameTab.removeScreenWidget((Screen)parent, (AbstractWidget)this.arrowRightButton);
                    } else {
                        parent.m_267719_();
                    }
                });
            }
            if (tabManager.m_267695_() != this) {
                return;
            }
            int midX = screen.f_96543_ / 2;
            int topY = this.nameEdit.m_252907_();
            ModernWorldCreationGameTab.removeScreenWidget((Screen)screen, (AbstractWidget)this.arrowLeftButton);
            this.arrowLeftButton = ModernWorldCreationGameTab.addRenderableWidgetToScreen((Screen)screen, new ArrowButton(midX - 145 - 40 - 10, topY + 38 + 22 - 20, ArrowButton.ArrowDirection.LEFT, button -> this.switchToNextGameMode(uiState, ArrowButton.ArrowDirection.LEFT)));
            if (FMUtils.isFancyMenuLoaded()) {
                FMAccess.setUniqueIdentifierToWidget(this.arrowLeftButton, "mwc_arrow_left_button");
            }
            ModernWorldCreationGameTab.removeScreenWidget((Screen)screen, (AbstractWidget)this.arrowRightButton);
            this.arrowRightButton = ModernWorldCreationGameTab.addRenderableWidgetToScreen((Screen)screen, new ArrowButton(midX + 55 + 90 + 10, topY + 38 + 22 - 20, ArrowButton.ArrowDirection.RIGHT, button -> this.switchToNextGameMode(uiState, ArrowButton.ArrowDirection.RIGHT)));
            if (FMUtils.isFancyMenuLoaded()) {
                FMAccess.setUniqueIdentifierToWidget(this.arrowRightButton, "mwc_arrow_right_button");
            }
            WorldCreationUiState.SelectedGameMode selectedGamemode = uiState.m_267761_();
            ModernWorldCreationGameTab.removeScreenWidget((Screen)screen, (AbstractWidget)this.gamemodeSurvivalButton);
            this.gamemodeSurvivalButton = ModernWorldCreationGameTab.addRenderableWidgetToScreen((Screen)screen, new ToggleModeButton(parent, midX - 145, topY + 38, 90, 45, BUTTON_TEXTURE_SURVIVAL, SURVIVAL_LABEL, button -> this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.SURVIVAL)));
            this.gamemodeSurvivalButton.setInfoTooltip(List.of(WorldCreationUiState.SelectedGameMode.SURVIVAL.m_267564_()));
            if (selectedGamemode == WorldCreationUiState.SelectedGameMode.SURVIVAL) {
                this.gamemodeSurvivalButton.setSelected(true);
            }
            if (FMUtils.isFancyMenuLoaded()) {
                FMAccess.setUniqueIdentifierToWidget(this.gamemodeSurvivalButton, "mwc_gamemode_survival_button");
            }
            ModernWorldCreationGameTab.removeScreenWidget((Screen)screen, (AbstractWidget)this.gamemodeCreativeButton);
            this.gamemodeCreativeButton = ModernWorldCreationGameTab.addRenderableWidgetToScreen((Screen)screen, new ToggleModeButton(parent, midX - 45, topY + 38, 90, 45, BUTTON_TEXTURE_CREATIVE, CREATIVE_LABEL, button -> this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.CREATIVE)));
            this.gamemodeCreativeButton.setInfoTooltip(List.of(WorldCreationUiState.SelectedGameMode.CREATIVE.m_267564_()));
            if (selectedGamemode == WorldCreationUiState.SelectedGameMode.CREATIVE) {
                this.gamemodeCreativeButton.setSelected(true);
            }
            if (FMUtils.isFancyMenuLoaded()) {
                FMAccess.setUniqueIdentifierToWidget(this.gamemodeCreativeButton, "mwc_gamemode_creative_button");
            }
            ModernWorldCreationGameTab.removeScreenWidget((Screen)screen, (AbstractWidget)this.gamemodeHardcoreButton);
            this.gamemodeHardcoreButton = ModernWorldCreationGameTab.addRenderableWidgetToScreen((Screen)screen, new ToggleModeButton(parent, midX + 55, topY + 38, 90, 45, BUTTON_TEXTURE_HARDCORE, HARDCORE_LABEL, button -> this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.HARDCORE)));
            this.gamemodeHardcoreButton.setInfoTooltip(List.of(WorldCreationUiState.SelectedGameMode.HARDCORE.m_267564_()));
            if (selectedGamemode == WorldCreationUiState.SelectedGameMode.HARDCORE) {
                this.gamemodeHardcoreButton.setSelected(true);
            }
            if (FMUtils.isFancyMenuLoaded()) {
                FMAccess.setUniqueIdentifierToWidget(this.gamemodeHardcoreButton, "mwc_gamemode_hardcore_button");
            }
            this.gamemodeSurvivalButton.setShowInfo(ModernWorldCreation.getOptions().showGameModeInfo.getValue());
            this.gamemodeCreativeButton.setShowInfo(ModernWorldCreation.getOptions().showGameModeInfo.getValue());
            this.gamemodeHardcoreButton.setShowInfo(ModernWorldCreation.getOptions().showGameModeInfo.getValue());
            this.difficultyButton.m_252865_(midX - this.difficultyButton.m_5711_() - 4);
            this.difficultyButton.m_253211_(topY + 38 + 50 + 10);
            this.allowCheatsButton.m_252865_(midX + 4);
            this.allowCheatsButton.m_253211_(topY + 38 + 50 + 10);
            if (this.experimentsButton != null) {
                this.experimentsButton.m_252865_(midX - this.experimentsButton.m_5711_() / 2);
                this.experimentsButton.m_253211_(this.difficultyButton.m_252907_() + this.difficultyButton.m_93694_() + 5);
            }
            if (screen.f_96544_ - this.allowCheatsButton.m_252907_() >= 100) {
                this.gamemodeSurvivalButton.m_253211_(this.gamemodeSurvivalButton.m_252907_() + 10);
                this.gamemodeCreativeButton.m_253211_(this.gamemodeCreativeButton.m_252907_() + 10);
                this.gamemodeHardcoreButton.m_253211_(this.gamemodeHardcoreButton.m_252907_() + 10);
                this.arrowLeftButton.m_253211_(this.arrowLeftButton.m_252907_() + 10);
                this.arrowRightButton.m_253211_(this.arrowRightButton.m_252907_() + 10);
                this.difficultyButton.m_253211_(this.difficultyButton.m_252907_() + 20);
                this.allowCheatsButton.m_253211_(this.allowCheatsButton.m_252907_() + 20);
                if (this.experimentsButton != null) {
                    this.experimentsButton.m_253211_(this.experimentsButton.m_252907_() + 20);
                }
            }
        });
    }

    protected void switchToNextGameMode(@NotNull WorldCreationUiState uiState, @NotNull ArrowButton.ArrowDirection direction) {
        if (direction == ArrowButton.ArrowDirection.LEFT) {
            if (uiState.m_267761_() == WorldCreationUiState.SelectedGameMode.SURVIVAL) {
                this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.HARDCORE);
            } else if (uiState.m_267761_() == WorldCreationUiState.SelectedGameMode.CREATIVE) {
                this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.SURVIVAL);
            } else if (uiState.m_267761_() == WorldCreationUiState.SelectedGameMode.HARDCORE) {
                this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.CREATIVE);
            }
        }
        if (direction == ArrowButton.ArrowDirection.RIGHT) {
            if (uiState.m_267761_() == WorldCreationUiState.SelectedGameMode.SURVIVAL) {
                this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.CREATIVE);
            } else if (uiState.m_267761_() == WorldCreationUiState.SelectedGameMode.CREATIVE) {
                this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.HARDCORE);
            } else if (uiState.m_267761_() == WorldCreationUiState.SelectedGameMode.HARDCORE) {
                this.setGameMode(uiState, WorldCreationUiState.SelectedGameMode.SURVIVAL);
            }
        }
    }

    protected void setGameMode(@NotNull WorldCreationUiState uiState, @NotNull WorldCreationUiState.SelectedGameMode gameMode) {
        uiState.m_267616_(gameMode);
        if (uiState.m_267761_() == WorldCreationUiState.SelectedGameMode.SURVIVAL) {
            this.gamemodeSurvivalButton.setSelected(true);
            this.gamemodeCreativeButton.setSelected(false);
            this.gamemodeHardcoreButton.setSelected(false);
        } else if (uiState.m_267761_() == WorldCreationUiState.SelectedGameMode.CREATIVE) {
            this.gamemodeSurvivalButton.setSelected(false);
            this.gamemodeCreativeButton.setSelected(true);
            this.gamemodeHardcoreButton.setSelected(false);
        } else if (uiState.m_267761_() == WorldCreationUiState.SelectedGameMode.HARDCORE) {
            this.gamemodeSurvivalButton.setSelected(false);
            this.gamemodeCreativeButton.setSelected(false);
            this.gamemodeHardcoreButton.setSelected(true);
        }
    }

    protected static <T extends AbstractWidget> T addRenderableWidgetToScreen(@NotNull Screen screen, @NotNull T widget) {
        ((IMixinScreen)screen).get_renderables_ModernWorldCreation().add((Renderable)widget);
        ((IMixinScreen)screen).get_children_ModernWorldCreation().add((GuiEventListener)widget);
        ((IMixinScreen)screen).get_narratables_ModernWorldCreation().add((NarratableEntry)widget);
        return widget;
    }

    protected static void removeScreenWidget(@NotNull Screen screen, @Nullable AbstractWidget widget) {
        if (widget == null) {
            return;
        }
        ((IMixinScreen)screen).get_renderables_ModernWorldCreation().remove(widget);
        ((IMixinScreen)screen).get_children_ModernWorldCreation().remove(widget);
        ((IMixinScreen)screen).get_narratables_ModernWorldCreation().remove(widget);
    }
}

