/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStartLookingAtBlockListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnStopLookingAtBlockListener
extends AbstractListener {
    @Nullable
    private OnStartLookingAtBlockListener.LookedBlockData lastBlockData;

    public OnStopLookingAtBlockListener() {
        super("stop_looking_at_block");
    }

    public void onStopLooking(@Nullable OnStartLookingAtBlockListener.LookedBlockData data) {
        this.lastBlockData = data;
        if (data != null) {
            this.notifyAllInstances();
        }
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("block_key", () -> {
            OnStartLookingAtBlockListener.LookedBlockData data = this.lastBlockData;
            if (data == null || data.blockKey() == null) {
                return "ERROR";
            }
            return data.blockKey();
        }));
        list.add(new AbstractListener.CustomVariable("block_pos_x", () -> {
            OnStartLookingAtBlockListener.LookedBlockData data = this.lastBlockData;
            if (data == null) {
                return "0";
            }
            return Integer.toString(data.blockPos().m_123341_());
        }));
        list.add(new AbstractListener.CustomVariable("block_pos_y", () -> {
            OnStartLookingAtBlockListener.LookedBlockData data = this.lastBlockData;
            if (data == null) {
                return "0";
            }
            return Integer.toString(data.blockPos().m_123342_());
        }));
        list.add(new AbstractListener.CustomVariable("block_pos_z", () -> {
            OnStartLookingAtBlockListener.LookedBlockData data = this.lastBlockData;
            if (data == null) {
                return "0";
            }
            return Integer.toString(data.blockPos().m_123343_());
        }));
        list.add(new AbstractListener.CustomVariable("distance_to_player", () -> {
            OnStartLookingAtBlockListener.LookedBlockData data = this.lastBlockData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.distance());
        }));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.m_237115_((String)"fancymenu.listeners.on_stop_looking_at_block");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_stop_looking_at_block.desc", new String[0]));
    }
}

