/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.stream.Stream;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.item.AzItemModelRenderer;
import mod.azure.azurelib.rewrite.render.item.AzItemRenderer;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererConfig;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererPipelineContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzItemRendererPipeline
extends AzRendererPipeline<ItemStack> {
    private final AzItemRenderer itemRenderer;
    protected Matrix4f itemRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzItemRendererPipeline(AzItemRendererConfig config, AzItemRenderer itemRenderer) {
        super(config);
        this.itemRenderer = itemRenderer;
    }

    @Override
    protected AzRendererPipelineContext<ItemStack> createContext(AzRendererPipeline<ItemStack> rendererPipeline) {
        return this.config.pipelineContext(this);
    }

    protected AzItemModelRenderer createModelRenderer(AzLayerRenderer<ItemStack> layerRenderer) {
        return (AzItemModelRenderer)this.config.modelRendererProvider(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<ItemStack> createLayerRenderer(AzRendererConfig<ItemStack> config) {
        return new AzLayerRenderer<ItemStack>(config::renderLayers);
    }

    @Override
    public void preRender(AzRendererPipelineContext<ItemStack> context, boolean isReRender) {
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)context;
        PoseStack poseStack = context.poseStack();
        this.itemRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        AzItemRendererConfig config = this.itemRenderer.config();
        float scaleWidth = config.scaleWidth(context.animatable());
        float scaleHeight = config.scaleHeight(context.animatable());
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        if (!isReRender) {
            boolean useNewOffset = config.useNewOffset();
            poseStack.m_252880_(0.5f, useNewOffset ? 0.0f : 0.51f, 0.5f);
        }
        Stream.of("leftArm", "rightArm").forEach(boneName -> context.bakedModel().getBone((String)boneName).ifPresent(bone -> {
            bone.setHidden(true);
            bone.setChildrenHidden(false);
        }));
        if (config.alpha(context.animatable()) < 1.0f) {
            itemContext.setAlpha(config.alpha(context.animatable()));
            itemContext.setTranslucent(true);
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<ItemStack> context, boolean isReRender) {
        this.config.postRenderEntry(context);
    }

    @Override
    public void updateAnimatedTextureFrame(ItemStack animatable) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(animatable));
    }

    public AzItemRenderer getRenderer() {
        return this.itemRenderer;
    }
}

