/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.helper;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class AzureVibrationUser
implements VibrationSystem.User {
    protected final Mob mob;
    protected final float moveSpeed;
    protected final int range;
    protected final PositionSource positionSource;

    public AzureVibrationUser(Mob entity, float speed, int range) {
        this.positionSource = new EntityPositionSource((Entity)entity, entity.m_20192_());
        this.mob = entity;
        this.moveSpeed = speed;
        this.range = range;
    }

    public int m_280351_() {
        return this.range;
    }

    public PositionSource m_280010_() {
        return this.positionSource;
    }

    public TagKey<GameEvent> m_280028_() {
        return GameEventTags.f_215853_;
    }

    public boolean m_280076_() {
        return true;
    }

    public boolean m_280612_(GameEvent gameEvent, GameEvent.Context context) {
        if (!gameEvent.m_204528_(this.m_280028_())) {
            return false;
        }
        Entity entity = context.f_223711_();
        if (entity != null) {
            if (entity.m_5833_()) {
                return false;
            }
            if (entity.m_20161_() && gameEvent.m_204528_(GameEventTags.f_144303_)) {
                return false;
            }
            if (entity.m_213854_()) {
                return false;
            }
        }
        if (context.f_223712_() != null) {
            return !context.f_223712_().m_204336_(BlockTags.f_215836_);
        }
        return true;
    }

    public boolean m_280080_(ServerLevel serverLevel, BlockPos blockPos, GameEvent gameEvent, GameEvent.Context context) {
        if (this.mob.m_21525_() || this.mob.m_21224_() || !this.mob.m_9236_().m_6857_().m_61937_(blockPos) || this.mob.m_213877_()) {
            return false;
        }
        Entity entity = context.f_223711_();
        return !(entity instanceof LivingEntity) || this.canTargetEntity((Entity)((LivingEntity)entity));
    }

    public void m_280271_(ServerLevel serverLevel, BlockPos blockPos, GameEvent gameEvent, @Nullable Entity entity, @Nullable Entity entity2, float f) {
        if (this.mob.m_21224_()) {
            return;
        }
        if (this.mob.m_20160_()) {
            return;
        }
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (this.mob.m_9236_() != entity.m_9236_()) {
            return false;
        }
        if (!EntitySelector.f_20406_.test(entity)) {
            return false;
        }
        if (this.mob.m_20160_()) {
            return false;
        }
        if (this.mob.m_7307_(entity)) {
            return false;
        }
        if (livingEntity.m_6336_() == MobType.f_21641_) {
            return false;
        }
        if (livingEntity.m_6095_() == EntityType.f_20529_) {
            return false;
        }
        if (livingEntity.m_6095_() == EntityType.f_217015_) {
            return false;
        }
        if (livingEntity instanceof Bat) {
            return false;
        }
        if (entity instanceof Marker) {
            return false;
        }
        if (entity instanceof AreaEffectCloud) {
            return false;
        }
        if (livingEntity.m_20147_()) {
            return false;
        }
        if (livingEntity.m_21224_()) {
            return false;
        }
        return this.mob.m_9236_().m_6857_().m_61935_(livingEntity.m_20191_());
    }
}

