/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import java.util.Collection;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public enum Shape {
    CUBE,
    CHEBYSHEV,
    STAR,
    MANHATTAN,
    SPHERE,
    EUCLIDEAN;


    public static Collection<BlockPos> getPositions(BlockPos center, Shape shape, int radius) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    if (shape != CUBE && shape != CHEBYSHEV && (shape != SPHERE && shape != EUCLIDEAN || i * i + j * j + k * k > radius * radius) && Math.abs(i) + Math.abs(j) + Math.abs(k) > radius) continue;
                    positions.add(new BlockPos((Vec3i)center.m_7918_(i, j, k)));
                }
            }
        }
        return positions;
    }

    public static double getDistance(Shape shape, double xDistance, double yDistance, double zDistance) {
        return switch (shape.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 4, 5 -> Math.sqrt(xDistance * xDistance + yDistance * yDistance + zDistance * zDistance);
            case 2, 3 -> xDistance + yDistance + zDistance;
            case 0, 1 -> Math.max(Math.max(xDistance, yDistance), zDistance);
        };
    }
}

