/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.common.collect.Lists;
import io.github.apace100.apoli.access.PowerCraftingInventory;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.mixin.CraftingInventoryAccessor;
import io.github.apace100.apoli.mixin.CraftingScreenHandlerAccessor;
import io.github.apace100.apoli.mixin.PlayerScreenHandlerAccessor;
import io.github.apace100.apoli.power.ModifyCraftingPower;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;

public class ModifiedCraftingRecipe
extends CustomRecipe {
    public static final RecipeSerializer<?> SERIALIZER = new SimpleCraftingRecipeSerializer(ModifiedCraftingRecipe::new);

    public ModifiedCraftingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        if (inventory instanceof TransientCraftingContainer) {
            TransientCraftingContainer craftingInventory = (TransientCraftingContainer)inventory;
            Optional<CraftingRecipe> original = this.getOriginalMatch(craftingInventory);
            if (original.isEmpty()) {
                return false;
            }
            return this.getRecipes(craftingInventory).stream().anyMatch(r -> r.doesApply(craftingInventory, (CraftingRecipe)original.get()));
        }
        return false;
    }

    public ItemStack craft(CraftingContainer inventory, RegistryAccess registryManager) {
        Optional<ModifyCraftingPower> optional;
        Optional<CraftingRecipe> original;
        TransientCraftingContainer craftingInventory;
        Player player;
        if (inventory instanceof TransientCraftingContainer && (player = ModifiedCraftingRecipe.getPlayerFromInventory(craftingInventory = (TransientCraftingContainer)inventory)) != null && (original = this.getOriginalMatch(craftingInventory)).isPresent() && (optional = this.getRecipes(craftingInventory).stream().filter(r -> r.doesApply(craftingInventory, (CraftingRecipe)original.get())).findFirst()).isPresent()) {
            ItemStack result = optional.get().getNewResult(craftingInventory, original.get());
            ((PowerCraftingInventory)craftingInventory).setPower(optional.get());
            return result;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static Player getPlayerFromInventory(TransientCraftingContainer inv) {
        AbstractContainerMenu handler = ((CraftingInventoryAccessor)inv).getHandler();
        return ModifiedCraftingRecipe.getPlayerFromHandler(handler);
    }

    public static Optional<BlockPos> getBlockFromInventory(TransientCraftingContainer inv) {
        AbstractContainerMenu handler = ((CraftingInventoryAccessor)inv).getHandler();
        if (handler instanceof CraftingMenu) {
            return ((CraftingScreenHandlerAccessor)handler).getContext().m_6721_((world, blockPos) -> blockPos);
        }
        return Optional.empty();
    }

    private List<ModifyCraftingPower> getRecipes(TransientCraftingContainer inv) {
        AbstractContainerMenu handler = ((CraftingInventoryAccessor)inv).getHandler();
        Player player = ModifiedCraftingRecipe.getPlayerFromHandler(handler);
        if (player != null) {
            return PowerHolderComponent.getPowers((Entity)player, ModifyCraftingPower.class);
        }
        return Lists.newArrayList();
    }

    private Optional<CraftingRecipe> getOriginalMatch(TransientCraftingContainer inv) {
        AbstractContainerMenu handler = ((CraftingInventoryAccessor)inv).getHandler();
        Player player = ModifiedCraftingRecipe.getPlayerFromHandler(handler);
        if (player != null && player.m_20194_() != null) {
            List recipes = player.m_20194_().m_129894_().m_44013_(RecipeType.f_44107_);
            return recipes.stream().filter(cr -> !(cr instanceof ModifiedCraftingRecipe) && cr.m_5818_((Container)inv, player.m_9236_())).findFirst();
        }
        return Optional.empty();
    }

    private static Player getPlayerFromHandler(AbstractContainerMenu screenHandler) {
        if (screenHandler instanceof CraftingMenu) {
            return ((CraftingScreenHandlerAccessor)screenHandler).getPlayer();
        }
        if (screenHandler instanceof InventoryMenu) {
            return ((PlayerScreenHandlerAccessor)screenHandler).getOwner();
        }
        return null;
    }
}

