/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.gson.JsonSyntaxException;
import io.github.apace100.apoli.data.DamageSourceDescription;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class MiscUtil {
    public static void createExplosion(Level world, Vec3 pos, float power, boolean createFire, Explosion.BlockInteraction destructionType, ExplosionDamageCalculator behavior) {
        MiscUtil.createExplosion(world, null, pos, power, createFire, destructionType, behavior);
    }

    public static void createExplosion(Level world, Entity entity, Vec3 pos, float power, boolean createFire, Explosion.BlockInteraction destructionType, ExplosionDamageCalculator behavior) {
        MiscUtil.createExplosion(world, entity, world.m_269111_().m_269093_(null), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), power, createFire, destructionType, behavior);
    }

    public static void createExplosion(Level world, Entity entity, DamageSource damageSource, double x, double y, double z, float power, boolean createFire, Explosion.BlockInteraction destructionType, ExplosionDamageCalculator behavior) {
        Explosion explosion = new Explosion(world, entity, damageSource, behavior, x, y, z, power, createFire, destructionType);
        explosion.m_46061_();
        explosion.m_46075_(world.f_46443_);
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        if (!explosion.m_254884_()) {
            explosion.m_46080_();
        }
        for (ServerPlayer serverPlayerEntity : serverWorld.m_6907_()) {
            if (!(serverPlayerEntity.m_20275_(x, y, z) < 4096.0)) continue;
            serverPlayerEntity.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, power, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverPlayerEntity)));
        }
    }

    @Nullable
    public static ExplosionDamageCalculator getExplosionBehavior(final Level world, final @Nullable Predicate<BlockInWorld> indestructibleCondition) {
        return indestructibleCondition == null ? null : new ExplosionDamageCalculator(){

            public boolean m_6714_(Explosion explosion, BlockGetter blockView, BlockPos pos, BlockState state, float power) {
                return !indestructibleCondition.test(new BlockInWorld((LevelReader)world, pos, true));
            }
        };
    }

    public static Optional<Entity> getEntityWithPassengers(Level world, EntityType<?> entityType, @Nullable CompoundTag entityNbt, Vec3 pos, float yaw, float pitch) {
        if (world.f_46443_) {
            return Optional.empty();
        }
        ServerLevel serverWorld = (ServerLevel)world;
        CompoundTag entityToSpawnNbt = new CompoundTag();
        if (entityNbt != null) {
            entityToSpawnNbt.m_128391_(entityNbt);
        }
        entityToSpawnNbt.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_(entityType).toString());
        Entity entityToSpawn = EntityType.m_20645_((CompoundTag)entityToSpawnNbt, (Level)serverWorld, entity -> {
            entity.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, yaw, pitch);
            return entity;
        });
        if (entityToSpawn == null) {
            return Optional.empty();
        }
        if (entityNbt == null && entityToSpawn instanceof Mob) {
            Mob mobToSpawn = (Mob)entityToSpawn;
            mobToSpawn.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(BlockPos.m_274446_((Position)pos)), MobSpawnType.COMMAND, null, null);
        }
        return Optional.of(entityToSpawn);
    }

    public static BlockState getInWallBlockState(LivingEntity playerEntity) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 8; ++i) {
            double d = playerEntity.m_20185_() + (double)(((float)((i >> 0) % 2) - 0.5f) * playerEntity.m_20205_() * 0.8f);
            double e = playerEntity.m_20188_() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double f = playerEntity.m_20189_() + (double)(((float)((i >> 2) % 2) - 0.5f) * playerEntity.m_20205_() * 0.8f);
            mutable.m_122169_(d, e, f);
            BlockState blockState = playerEntity.m_9236_().m_8055_((BlockPos)mutable);
            if (blockState.m_60799_() == RenderShape.INVISIBLE || !blockState.m_60831_((BlockGetter)playerEntity.m_9236_(), (BlockPos)mutable)) continue;
            return blockState;
        }
        return null;
    }

    public static <T> Predicate<T> combineOr(Predicate<T> a, Predicate<T> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.or(b);
    }

    public static <T> Predicate<T> combineAnd(Predicate<T> a, Predicate<T> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.and(b);
    }

    public static DamageSource createDamageSource(DamageSources damageSources, @Nullable DamageSourceDescription damageSourceDescription, @Nullable ResourceKey<DamageType> damageType) {
        if (damageSourceDescription == null && damageType == null) {
            throw new JsonSyntaxException("Either a legacy damage source or an ID of a damage type must be specified");
        }
        return damageSourceDescription == null ? damageSources.m_269079_(damageType) : damageSourceDescription.create(damageSources);
    }

    public static DamageSource createDamageSource(DamageSources damageSources, @Nullable DamageSourceDescription damageSourceDescription, @Nullable ResourceKey<DamageType> damageType, Entity attacker) {
        if (damageSourceDescription == null && damageType == null) {
            throw new JsonSyntaxException("Either a legacy damage source or an ID of a damage type must be specified");
        }
        return damageSourceDescription == null ? damageSources.m_269298_(damageType, attacker) : damageSourceDescription.create(damageSources, attacker);
    }

    public static DamageSource createDamageSource(DamageSources damageSources, @Nullable DamageSourceDescription damageSourceDescription, @Nullable ResourceKey<DamageType> damageType, Entity source, Entity attacker) {
        if (damageSourceDescription == null && damageType == null) {
            throw new JsonSyntaxException("Either a legacy damage source or an ID of a damage type must be specified");
        }
        return damageSourceDescription == null ? damageSources.m_268998_(damageType, source, attacker) : damageSourceDescription.create(damageSources, source, attacker);
    }
}

