/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.mixin.ItemSlotArgumentTypeAccessor;
import io.github.apace100.apoli.power.InventoryPower;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.util.ArgumentWrapper;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryUtil {
    public static Set<Integer> getSlots(SerializableData.Instance data) {
        HashSet<Integer> slots = new HashSet<Integer>();
        data.ifPresent("slot", iaw -> slots.add((Integer)iaw.get()));
        data.ifPresent("slots", iaws -> slots.addAll(iaws.stream().map(ArgumentWrapper::get).toList()));
        if (slots.isEmpty()) {
            slots.addAll(ItemSlotArgumentTypeAccessor.getSlotMappings().values());
        }
        return slots;
    }

    public static int checkInventory(SerializableData.Instance data, Entity entity, InventoryPower inventoryPower, Function<ItemStack, Integer> processor) {
        Predicate itemCondition = (Predicate)data.get("item_condition");
        Set<Integer> slots = InventoryUtil.getSlots(data);
        InventoryUtil.deduplicateSlots(entity, slots);
        int matches = 0;
        if (inventoryPower == null) {
            for (int slot : slots) {
                SlotAccess stackReference = entity.m_141942_(slot);
                if (stackReference == SlotAccess.f_147290_) continue;
                ItemStack stack = stackReference.m_142196_();
                if ((itemCondition != null || stack.m_41619_()) && itemCondition != null && !itemCondition.test(stack)) continue;
                matches += processor.apply(stack).intValue();
            }
        } else {
            for (int slot : slots) {
                if (slot < 0 || slot >= inventoryPower.m_6643_()) continue;
                ItemStack stack = inventoryPower.m_8020_(slot);
                if ((itemCondition != null || stack.m_41619_()) && itemCondition != null && !itemCondition.test(stack)) continue;
                matches += processor.apply(stack).intValue();
            }
        }
        return matches;
    }

    public static void modifyInventory(SerializableData.Instance data, Entity entity, InventoryPower inventoryPower, Function<ItemStack, Integer> processor, int limit) {
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        Set<Integer> slots = InventoryUtil.getSlots(data);
        InventoryUtil.deduplicateSlots(entity, slots);
        Consumer entityAction = (Consumer)data.get("entity_action");
        Predicate itemCondition = (Predicate)data.get("item_condition");
        ActionFactory.Instance itemAction = (ActionFactory.Instance)data.get("item_action");
        int counter = 0;
        if (inventoryPower == null) {
            for (int slot2 : slots) {
                ItemStack itemStack;
                SlotAccess stackReference = entity.m_141942_(slot2);
                if (stackReference == SlotAccess.f_147290_ || (itemStack = stackReference.m_142196_()).m_41619_() || itemCondition != null && !itemCondition.test(itemStack)) continue;
                if (entityAction != null) {
                    entityAction.accept(entity);
                }
                int amount = processor.apply(itemStack);
                for (int i = 0; i < amount; ++i) {
                    itemAction.accept(new Tuple((Object)entity.m_9236_(), (Object)itemStack));
                    if (++counter >= limit) break;
                }
                if (counter < limit) continue;
                break;
            }
        } else {
            slots.removeIf(slot -> slot < 0 || slot >= inventoryPower.m_6643_());
            for (int slot3 : slots) {
                ItemStack itemStack = inventoryPower.m_8020_(slot3);
                if (itemStack.m_41619_() || itemCondition != null && !itemCondition.test(itemStack)) continue;
                if (entityAction != null) {
                    entityAction.accept(entity);
                }
                int amount = processor.apply(itemStack);
                for (int i = 0; i < amount; ++i) {
                    itemAction.accept(new Tuple((Object)entity.m_9236_(), (Object)itemStack));
                    if (++counter >= limit) break;
                }
                if (counter < limit) continue;
                break;
            }
        }
    }

    public static void replaceInventory(SerializableData.Instance data, Entity entity, InventoryPower inventoryPower) {
        Set<Integer> slots = InventoryUtil.getSlots(data);
        InventoryUtil.deduplicateSlots(entity, slots);
        Consumer entityAction = (Consumer)data.get("entity_action");
        Predicate itemCondition = (Predicate)data.get("item_condition");
        Consumer itemAction = (Consumer)data.get("item_action");
        ItemStack replacementStack = (ItemStack)data.get("stack");
        boolean mergeNbt = data.getBoolean("merge_nbt");
        if (inventoryPower == null) {
            slots.forEach(slot -> {
                SlotAccess stackReference = entity.m_141942_(slot.intValue());
                if (stackReference == SlotAccess.f_147290_) {
                    return;
                }
                ItemStack itemStack = stackReference.m_142196_();
                if (itemCondition != null && !itemCondition.test(itemStack)) {
                    return;
                }
                if (entityAction != null) {
                    entityAction.accept(entity);
                }
                ItemStack stackAfterReplacement = replacementStack.m_41777_();
                if (mergeNbt && itemStack.m_41782_()) {
                    itemStack.m_41784_().m_128391_(stackAfterReplacement.m_41784_());
                    stackAfterReplacement.m_41751_(itemStack.m_41784_());
                }
                stackReference.m_142104_(stackAfterReplacement);
                if (itemAction != null) {
                    itemAction.accept(new Tuple((Object)entity.m_9236_(), (Object)stackAfterReplacement));
                }
            });
        } else {
            slots.removeIf(slot -> slot < 0 || slot >= inventoryPower.m_6643_());
            slots.forEach(slot -> {
                ItemStack itemStack = inventoryPower.m_8020_((int)slot);
                if (itemCondition != null && !itemCondition.test(itemStack)) {
                    return;
                }
                if (entityAction != null) {
                    entityAction.accept(entity);
                }
                ItemStack stackAfterReplacement = replacementStack.m_41777_();
                if (mergeNbt && itemStack.m_41782_()) {
                    itemStack.m_41784_().m_128391_(stackAfterReplacement.m_41784_());
                    stackAfterReplacement.m_41751_(itemStack.m_41784_());
                }
                inventoryPower.m_6836_((int)slot, stackAfterReplacement);
                if (itemAction != null) {
                    itemAction.accept(new Tuple((Object)entity.m_9236_(), (Object)stackAfterReplacement));
                }
            });
        }
    }

    public static void dropInventory(SerializableData.Instance data, Entity entity, InventoryPower inventoryPower) {
        Set<Integer> slots = InventoryUtil.getSlots(data);
        InventoryUtil.deduplicateSlots(entity, slots);
        int amount = data.getInt("amount");
        boolean throwRandomly = data.getBoolean("throw_randomly");
        boolean retainOwnership = data.getBoolean("retain_ownership");
        Consumer entityAction = (Consumer)data.get("entity_action");
        Predicate itemCondition = (Predicate)data.get("item_condition");
        Consumer itemAction = (Consumer)data.get("item_action");
        if (inventoryPower == null) {
            slots.forEach(slot -> {
                SlotAccess stackReference = entity.m_141942_(slot.intValue());
                if (stackReference == SlotAccess.f_147290_) {
                    return;
                }
                ItemStack itemStack = stackReference.m_142196_();
                if (itemStack.m_41619_()) {
                    return;
                }
                if (itemCondition != null && !itemCondition.test(itemStack)) {
                    return;
                }
                if (entityAction != null) {
                    entityAction.accept(entity);
                }
                if (itemAction != null) {
                    itemAction.accept(new Tuple((Object)entity.m_9236_(), (Object)itemStack));
                }
                if (amount != 0) {
                    int newAmount = amount < 0 ? amount * -1 : amount;
                    ItemStack droppedStack = itemStack.m_41620_(newAmount);
                    InventoryUtil.throwItem(entity, droppedStack, throwRandomly, retainOwnership);
                    stackReference.m_142104_(itemStack);
                } else {
                    InventoryUtil.throwItem(entity, itemStack, throwRandomly, retainOwnership);
                    stackReference.m_142104_(ItemStack.f_41583_);
                }
            });
        } else {
            slots.removeIf(slot -> slot < 0 || slot >= inventoryPower.m_6643_());
            slots.forEach(slot -> {
                ItemStack itemStack = inventoryPower.m_8020_((int)slot);
                if (itemStack.m_41619_()) {
                    return;
                }
                if (itemCondition != null && !itemCondition.test(itemStack)) {
                    return;
                }
                if (entityAction != null) {
                    entityAction.accept(entity);
                }
                if (itemAction != null) {
                    itemAction.accept(new Tuple((Object)entity.m_9236_(), (Object)itemStack));
                }
                if (amount != 0) {
                    int newAmount = amount < 0 ? amount * -1 : amount;
                    ItemStack droppedStack = itemStack.m_41620_(newAmount);
                    InventoryUtil.throwItem(entity, droppedStack, throwRandomly, retainOwnership);
                    inventoryPower.m_6836_((int)slot, itemStack);
                } else {
                    InventoryUtil.throwItem(entity, itemStack, throwRandomly, retainOwnership);
                    inventoryPower.m_6836_((int)slot, ItemStack.f_41583_);
                }
            });
        }
    }

    public static void throwItem(Entity thrower, ItemStack itemStack, boolean throwRandomly, boolean retainOwnership) {
        if (itemStack.m_41619_()) {
            return;
        }
        if (thrower instanceof Player) {
            Player playerEntity = (Player)thrower;
            if (playerEntity.m_9236_().f_46443_) {
                playerEntity.m_6674_(InteractionHand.MAIN_HAND);
            }
        }
        double yOffset = thrower.m_20188_() - (double)0.3f;
        ItemEntity itemEntity = new ItemEntity(thrower.m_9236_(), thrower.m_20185_(), yOffset, thrower.m_20189_(), itemStack);
        itemEntity.m_32010_(40);
        Random random = new Random();
        if (retainOwnership) {
            itemEntity.m_32052_(thrower.m_20148_());
        }
        if (throwRandomly) {
            float f = random.nextFloat() * 0.5f;
            float g = random.nextFloat() * ((float)Math.PI * 2);
            itemEntity.m_20334_((double)(-Mth.m_14031_((float)g) * f), (double)0.2f, (double)(Mth.m_14089_((float)g) * f));
        } else {
            float f = 0.3f;
            float g = Mth.m_14031_((float)(thrower.m_146909_() * ((float)Math.PI / 180)));
            float h = Mth.m_14089_((float)(thrower.m_146909_() * ((float)Math.PI / 180)));
            float i = Mth.m_14031_((float)(thrower.m_146908_() * ((float)Math.PI / 180)));
            float j = Mth.m_14089_((float)(thrower.m_146908_() * ((float)Math.PI / 180)));
            float k = random.nextFloat() * ((float)Math.PI * 2);
            float l = 0.02f * random.nextFloat();
            itemEntity.m_20334_((double)(-i * h * f) + Math.cos(k) * (double)l, (double)(-g * f + 0.1f + (random.nextFloat() - random.nextFloat()) * 0.1f), (double)(j * h * f) + Math.sin(k) * (double)l);
        }
        thrower.m_9236_().m_7967_((Entity)itemEntity);
    }

    public static void forEachStack(Entity entity, Consumer<ItemStack> itemStackConsumer) {
        int skip = InventoryUtil.getDuplicatedSlotIndex(entity);
        for (int slot : ItemSlotArgumentTypeAccessor.getSlotMappings().values()) {
            ItemStack itemStack;
            if (slot == skip) {
                skip = Integer.MIN_VALUE;
                continue;
            }
            SlotAccess stackReference = entity.m_141942_(slot);
            if (stackReference == SlotAccess.f_147290_ || (itemStack = stackReference.m_142196_()).m_41619_()) continue;
            itemStackConsumer.accept(itemStack);
        }
        Optional optionalPowerHolderComponent = PowerHolderComponent.KEY.maybeGet((Object)entity);
        if (optionalPowerHolderComponent.isPresent()) {
            PowerHolderComponent phc = (PowerHolderComponent)optionalPowerHolderComponent.get();
            List<InventoryPower> inventoryPowers = phc.getPowers(InventoryPower.class);
            for (InventoryPower inventoryPower : inventoryPowers) {
                for (int index = 0; index < inventoryPower.m_6643_(); ++index) {
                    ItemStack stack = inventoryPower.m_8020_(index);
                    if (stack.m_41619_()) continue;
                    itemStackConsumer.accept(stack);
                }
            }
        }
    }

    private static void deduplicateSlots(Entity entity, Set<Integer> slots) {
        int hotbarSlot = InventoryUtil.getDuplicatedSlotIndex(entity);
        if (hotbarSlot != Integer.MIN_VALUE && slots.contains(hotbarSlot)) {
            Integer mainHandSlot = ItemSlotArgumentTypeAccessor.getSlotMappings().get("weapon.mainhand");
            slots.remove(mainHandSlot);
        }
    }

    private static int getDuplicatedSlotIndex(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int selectedSlot = player.m_150109_().f_35977_;
            return ItemSlotArgumentTypeAccessor.getSlotMappings().get("hotbar." + selectedSlot);
        }
        return Integer.MIN_VALUE;
    }

    public static enum ProcessMode {
        STACKS(stack -> 1),
        ITEMS(ItemStack::m_41613_);

        private final Function<ItemStack, Integer> processor;

        private ProcessMode(Function<ItemStack, Integer> processor) {
            this.processor = processor;
        }

        public Function<ItemStack, Integer> getProcessor() {
            return this.processor;
        }
    }

    public static enum InventoryType {
        INVENTORY,
        POWER;

    }
}

