/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.apace100.apoli.util.StackPowerUtil;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AddPowerLootFunction
extends LootItemConditionalFunction {
    public static final LootItemFunctionType TYPE = new LootItemFunctionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    private final EquipmentSlot slot;
    private final ResourceLocation powerId;
    private final boolean hidden;
    private final boolean negative;

    private AddPowerLootFunction(LootItemCondition[] conditions, EquipmentSlot slot, ResourceLocation powerId, boolean hidden, boolean negative) {
        super(conditions);
        this.slot = slot;
        this.powerId = powerId;
        this.hidden = hidden;
        this.negative = negative;
    }

    public LootItemFunctionType m_7162_() {
        return TYPE;
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        StackPowerUtil.addPower(stack, this.slot, this.powerId, this.hidden, this.negative);
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder(EquipmentSlot slot, ResourceLocation powerId, boolean hidden, boolean negative) {
        return AddPowerLootFunction.m_80683_(conditions -> new AddPowerLootFunction((LootItemCondition[])conditions, slot, powerId, hidden, negative));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<AddPowerLootFunction> {
        public void toJson(JsonObject jsonObject, AddPowerLootFunction addPowerLootFunction, JsonSerializationContext jsonSerializationContext) {
            super.m_6170_(jsonObject, (LootItemConditionalFunction)addPowerLootFunction, jsonSerializationContext);
            jsonObject.addProperty("slot", addPowerLootFunction.slot.m_20751_());
            jsonObject.addProperty("power", addPowerLootFunction.powerId.toString());
        }

        public AddPowerLootFunction fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootConditions) {
            EquipmentSlot slot = (EquipmentSlot)SerializableDataTypes.EQUIPMENT_SLOT.read(jsonObject.get("slot"));
            ResourceLocation powerId = (ResourceLocation)SerializableDataTypes.IDENTIFIER.read(jsonObject.get("power"));
            boolean hidden = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"hidden", (boolean)false);
            boolean negative = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"negative", (boolean)false);
            return new AddPowerLootFunction(lootConditions, slot, powerId, hidden, negative);
        }
    }
}

