/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.screen;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.HudRendered;
import io.github.apace100.apoli.screen.GameHudRender;
import io.github.apace100.apoli.util.ApoliConfigClient;
import io.github.apace100.apoli.util.HudRender;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PowerHudRenderer
implements GameHudRender {
    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(GuiGraphics context, float delta) {
        Minecraft client = Minecraft.m_91087_();
        PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)client.f_91074_);
        int x = client.m_91268_().m_85445_() / 2 + 20 + ((ApoliConfigClient)Apoli.config).resourcesAndCooldowns.hudOffsetX;
        int y = client.m_91268_().m_85446_() - 47 + ((ApoliConfigClient)Apoli.config).resourcesAndCooldowns.hudOffsetY;
        Entity vehicle = client.f_91074_.m_20202_();
        if (vehicle instanceof LivingEntity) {
            y -= 8 * (int)(((LivingEntity)vehicle).m_21233_() / 20.0f);
        }
        if (client.f_91074_.m_204029_(FluidTags.f_13131_) || client.f_91074_.m_20146_() < client.f_91074_.m_6062_()) {
            y -= 8;
        }
        int barWidth = 71;
        int barHeight = 8;
        int iconSize = 8;
        List hudPowers = component.getPowers().stream().filter(p -> p instanceof HudRendered).map(p -> (HudRendered)((Object)p)).sorted(Comparator.comparing(hudRenderedA -> hudRenderedA.getRenderSettings().getSpriteLocation())).collect(Collectors.toList());
        for (HudRendered hudPower : hudPowers) {
            HudRender render = hudPower.getRenderSettings();
            if (!render.shouldRender((Player)client.f_91074_) || !hudPower.shouldRender()) continue;
            ResourceLocation currentLocation = render.getSpriteLocation();
            context.m_280218_(currentLocation, x, y, 0, 0, barWidth, 5);
            int v = 8 + render.getBarIndex() * 10;
            float fill = hudPower.getFill();
            if (render.isInverted()) {
                fill = 1.0f - fill;
            }
            int w = (int)(fill * (float)barWidth);
            context.m_280218_(currentLocation, x, y - 2, 0, v, w, barHeight);
            context.m_280218_(currentLocation, x - iconSize - 2, y - 2, 73, v, iconSize, iconSize);
            y -= 8;
        }
    }
}

