/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition.entity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RaycastCondition {
    public static boolean condition(SerializableData.Instance data, Entity entity) {
        BlockHitResult blockHit;
        Vec3 origin = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        Vec3 direction = entity.m_20252_(1.0f);
        Vec3 target = origin.m_82549_(direction.m_82490_(((Double)data.get("distance")).doubleValue()));
        EntityHitResult hitResult = null;
        if (data.getBoolean("entity")) {
            hitResult = RaycastCondition.performEntityRaycast(entity, origin, target, (ConditionFactory.Instance)data.get("match_bientity_condition"));
        }
        if (data.getBoolean("block") && (blockHit = RaycastCondition.performBlockRaycast(entity, origin, target, (ClipContext.Block)data.get("shape_type"), (ClipContext.Fluid)data.get("fluid_handling"))).m_6662_() != HitResult.Type.MISS) {
            if (hitResult == null || hitResult.m_6662_() == HitResult.Type.MISS) {
                hitResult = blockHit;
            } else if (hitResult.m_82448_(entity) > blockHit.m_82448_(entity)) {
                hitResult = blockHit;
            }
        }
        if (hitResult != null && hitResult.m_6662_() != HitResult.Type.MISS) {
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult bhr = (BlockHitResult)hitResult;
                if (data.isPresent("block_condition")) {
                    BlockInWorld cbp = new BlockInWorld((LevelReader)entity.m_9236_(), bhr.m_82425_(), true);
                    return ((Predicate)data.get("block_condition")).test(cbp);
                }
            }
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult ehr = hitResult;
                if (data.isPresent("hit_bientity_condition")) {
                    return ((Predicate)data.get("hit_bientity_condition")).test(new Tuple((Object)entity, (Object)ehr.m_82443_()));
                }
            }
            return true;
        }
        return false;
    }

    private static BlockHitResult performBlockRaycast(Entity source, Vec3 origin, Vec3 target, ClipContext.Block shapeType, ClipContext.Fluid fluidHandling) {
        ClipContext context = new ClipContext(origin, target, shapeType, fluidHandling, source);
        return source.m_9236_().m_45547_(context);
    }

    private static EntityHitResult performEntityRaycast(Entity source, Vec3 origin, Vec3 target, ConditionFactory.Instance biEntityCondition) {
        Vec3 ray = target.m_82546_(origin);
        AABB box = source.m_20191_().m_82369_(ray).m_82377_(1.0, 1.0, 1.0);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)source, (Vec3)origin, (Vec3)target, (AABB)box, entityx -> !entityx.m_5833_() && (biEntityCondition == null || biEntityCondition.test(new Tuple((Object)source, entityx))), (double)ray.m_82556_());
        return entityHitResult;
    }

    public static ConditionFactory<Entity> getFactory() {
        return new ConditionFactory<Entity>(Apoli.identifier("raycast"), new SerializableData().add("distance", SerializableDataTypes.DOUBLE).add("block", SerializableDataTypes.BOOLEAN, (Object)true).add("entity", SerializableDataTypes.BOOLEAN, (Object)true).add("shape_type", SerializableDataType.enumValue(ClipContext.Block.class), (Object)ClipContext.Block.OUTLINE).add("fluid_handling", SerializableDataType.enumValue(ClipContext.Fluid.class), (Object)ClipContext.Fluid.ANY).add("match_bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("hit_bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null), RaycastCondition::condition);
    }
}

