/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition.block;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.data.LegacyMaterial;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import java.util.List;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class MaterialCondition {
    public static boolean condition(SerializableData.Instance data, BlockInWorld cachedBlockPosition) {
        BlockState blockState = cachedBlockPosition.m_61168_();
        if (data.isPresent("material") && ((LegacyMaterial)data.get("material")).blockStateIsOfMaterial(blockState)) {
            return true;
        }
        if (data.isPresent("materials")) {
            return ((List)data.get("materials")).stream().anyMatch(m -> m.blockStateIsOfMaterial(blockState));
        }
        return false;
    }

    public static ConditionFactory<BlockInWorld> getFactory() {
        return new ConditionFactory<BlockInWorld>(Apoli.identifier("material"), new SerializableData().add("material", ApoliDataTypes.LEGACY_MATERIAL, null).add("materials", ApoliDataTypes.LEGACY_MATERIALS, null), MaterialCondition::condition);
    }
}

