/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition.bientity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class RelativeRotationCondition {
    public static boolean condition(SerializableData.Instance data, Tuple<Entity, Entity> pair) {
        RotationType actorRotation = (RotationType)((Object)data.get("actor_rotation"));
        RotationType targetRotation = (RotationType)((Object)data.get("target_rotation"));
        Vec3 vec0 = actorRotation.getRotation((Entity)pair.m_14418_());
        Vec3 vec1 = targetRotation.getRotation((Entity)pair.m_14419_());
        EnumSet axes = (EnumSet)data.get("axes");
        vec0 = RelativeRotationCondition.reduceAxes(vec0, axes);
        vec1 = RelativeRotationCondition.reduceAxes(vec1, axes);
        double angle = RelativeRotationCondition.getAngleBetween(vec0, vec1);
        Comparison comparison = (Comparison)((Object)data.get("comparison"));
        double compareTo = data.getDouble("compare_to");
        return comparison.compare(angle, compareTo);
    }

    private static double getAngleBetween(Vec3 a, Vec3 b) {
        double dot = a.m_82526_(b);
        return dot / (a.m_82553_() * b.m_82553_());
    }

    private static Vec3 reduceAxes(Vec3 vector, EnumSet<Direction.Axis> axesToKeep) {
        return new Vec3(axesToKeep.contains(Direction.Axis.X) ? vector.f_82479_ : 0.0, axesToKeep.contains(Direction.Axis.Y) ? vector.f_82480_ : 0.0, axesToKeep.contains(Direction.Axis.Z) ? vector.f_82481_ : 0.0);
    }

    public static ConditionFactory<Tuple<Entity, Entity>> getFactory() {
        return new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("relative_rotation"), new SerializableData().add("axes", SerializableDataTypes.AXIS_SET, EnumSet.allOf(Direction.Axis.class)).add("actor_rotation", SerializableDataType.enumValue(RotationType.class), (Object)RotationType.HEAD).add("target_rotation", SerializableDataType.enumValue(RotationType.class), (Object)RotationType.BODY).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.DOUBLE), RelativeRotationCondition::condition);
    }

    private static Vec3 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = Mth.m_14089_((float)g);
        float i = Mth.m_14031_((float)g);
        float j = Mth.m_14089_((float)f);
        float k = Mth.m_14031_((float)f);
        return new Vec3((double)(i * j), (double)(-k), (double)(h * j));
    }

    public static enum RotationType {
        HEAD(e -> e.m_20252_(1.0f)),
        BODY(e -> {
            if (e instanceof LivingEntity) {
                LivingEntity l = (LivingEntity)e;
                return RelativeRotationCondition.getRotationVector(0.0f, l.f_20883_);
            }
            return e.m_20252_(1.0f);
        });

        private final Function<Entity, Vec3> function;

        private RotationType(Function<Entity, Vec3> function) {
            this.function = function;
        }

        public Vec3 getRotation(Entity entity) {
            return this.function.apply(entity);
        }
    }
}

