/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.FluidState;

public class FluidConditions {
    public static void register() {
        FluidConditions.register(new ConditionFactory<FluidState>(Apoli.identifier("constant"), new SerializableData().add("value", SerializableDataTypes.BOOLEAN), (data, fluid) -> data.getBoolean("value")));
        FluidConditions.register(new ConditionFactory<FluidState>(Apoli.identifier("and"), new SerializableData().add("conditions", ApoliDataTypes.FLUID_CONDITIONS), (data, fluid) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(fluid))));
        FluidConditions.register(new ConditionFactory<FluidState>(Apoli.identifier("or"), new SerializableData().add("conditions", ApoliDataTypes.FLUID_CONDITIONS), (data, fluid) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(fluid))));
        FluidConditions.register(new ConditionFactory<FluidState>(Apoli.identifier("empty"), new SerializableData(), (data, fluid) -> fluid.m_76178_()));
        FluidConditions.register(new ConditionFactory<FluidState>(Apoli.identifier("still"), new SerializableData(), (data, fluid) -> fluid.m_76170_()));
        FluidConditions.register(new ConditionFactory<FluidState>(Apoli.identifier("in_tag"), new SerializableData().add("tag", SerializableDataTypes.FLUID_TAG), (data, fluid) -> fluid.m_205074_().m_203656_((TagKey)data.get("tag"))));
        FluidConditions.register(new ConditionFactory<FluidState>(Apoli.identifier("fluid"), new SerializableData().add("fluid", SerializableDataTypes.FLUID), (data, fluid) -> fluid.m_76152_() == data.get("fluid")));
    }

    private static void register(ConditionFactory<FluidState> conditionFactory) {
        Registry.m_122965_(ApoliRegistries.FLUID_CONDITION, (ResourceLocation)conditionFactory.getSerializerId(), conditionFactory);
    }
}

