/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class EntityConditionsServer {
    public static void register() {
        EntityConditionsServer.register(new ConditionFactory<Entity>(Apoli.identifier("using_effective_tool"), new SerializableData(), (data, entity) -> {
            if (entity instanceof ServerPlayer) {
                ServerPlayerGameMode interactionMngr = ((ServerPlayer)entity).f_8941_;
                if (interactionMngr.f_9249_) {
                    return ((Player)entity).m_36298_(entity.m_9236_().m_8055_(interactionMngr.f_9251_));
                }
            }
            return false;
        }));
        EntityConditionsServer.register(new ConditionFactory<Entity>(Apoli.identifier("gamemode"), new SerializableData().add("gamemode", SerializableDataTypes.STRING), (data, entity) -> {
            if (entity instanceof ServerPlayer) {
                ServerPlayerGameMode interactionMngr = ((ServerPlayer)entity).f_8941_;
                return interactionMngr.m_9290_().m_46405_().equals(data.getString("gamemode"));
            }
            return false;
        }));
        EntityConditionsServer.register(new ConditionFactory<Entity>(Apoli.identifier("advancement"), new SerializableData().add("advancement", SerializableDataTypes.IDENTIFIER), (data, entity) -> {
            ResourceLocation id = data.getId("advancement");
            if (entity instanceof ServerPlayer) {
                Advancement advancement = entity.m_20194_().m_129889_().m_136041_(id);
                if (advancement == null) {
                    Apoli.LOGGER.warn("Advancement \"" + String.valueOf(id) + "\" did not exist, but was referenced in an \"origins:advancement\" condition.");
                } else {
                    return ((ServerPlayer)entity).m_8960_().m_135996_(advancement).m_8193_();
                }
            }
            return false;
        }));
        EntityConditionsServer.register(new ConditionFactory<Entity>(Apoli.identifier("glowing"), new SerializableData(), (data, entity) -> entity.m_142038_()));
    }

    private static void register(ConditionFactory<Entity> conditionFactory) {
        Registry.m_122965_(ApoliRegistries.ENTITY_CONDITION, (ResourceLocation)conditionFactory.getSerializerId(), conditionFactory);
    }
}

