/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.mixin.ClientAdvancementManagerAccessor;
import io.github.apace100.apoli.mixin.ClientPlayerInteractionManagerAccessor;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class EntityConditionsClient {
    @Environment(value=EnvType.CLIENT)
    public static void register() {
        EntityConditionsClient.register(new ConditionFactory<Entity>(Apoli.identifier("using_effective_tool"), new SerializableData(), (data, entity) -> {
            ClientPlayerInteractionManagerAccessor interactionMngr;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ServerPlayerGameMode interactionMngr2 = ((ServerPlayer)entity).f_8941_;
                if (interactionMngr2.f_9249_) {
                    return ((Player)entity).m_36298_(entity.m_9236_().m_8055_(interactionMngr2.f_9251_));
                }
            } else if (entity instanceof LocalPlayer && (interactionMngr = (ClientPlayerInteractionManagerAccessor)Minecraft.m_91087_().f_91072_).getBreakingBlock()) {
                return ((Player)entity).m_36298_(entity.m_9236_().m_8055_(interactionMngr.getCurrentBreakingPos()));
            }
            return false;
        }));
        EntityConditionsClient.register(new ConditionFactory<Entity>(Apoli.identifier("gamemode"), new SerializableData().add("gamemode", SerializableDataTypes.STRING), (data, entity) -> {
            if (entity instanceof ServerPlayer) {
                ServerPlayerGameMode interactionMngr = ((ServerPlayer)entity).f_8941_;
                return interactionMngr.m_9290_().m_46405_().equals(data.getString("gamemode"));
            }
            if (entity instanceof LocalPlayer) {
                ClientPlayerInteractionManagerAccessor interactionMngr = (ClientPlayerInteractionManagerAccessor)Minecraft.m_91087_().f_91072_;
                return interactionMngr.getGameMode().m_46405_().equals(data.getString("gamemode"));
            }
            return false;
        }));
        EntityConditionsClient.register(new ConditionFactory<Entity>(Apoli.identifier("advancement"), new SerializableData().add("advancement", SerializableDataTypes.IDENTIFIER), (data, entity) -> {
            ResourceLocation id = data.getId("advancement");
            if (entity instanceof ServerPlayer) {
                Advancement advancement = entity.m_20194_().m_129889_().m_136041_(id);
                if (advancement != null) return ((ServerPlayer)entity).m_8960_().m_135996_(advancement).m_8193_();
                Apoli.LOGGER.warn("Advancement \"" + String.valueOf(id) + "\" did not exist, but was referenced in an \"origins:advancement\" condition.");
                return false;
            } else {
                Map<Advancement, AdvancementProgress> progressMap;
                ClientAdvancements advancementManager;
                Advancement advancement;
                if (!(entity instanceof LocalPlayer) || (advancement = (advancementManager = Minecraft.m_91087_().m_91403_().m_105145_()).m_104396_().m_139337_(id)) == null || !(progressMap = ((ClientAdvancementManagerAccessor)advancementManager).getAdvancementProgresses()).containsKey(advancement)) return false;
                return progressMap.get(advancement).m_8193_();
            }
        }));
        EntityConditionsClient.register(new ConditionFactory<Entity>(Apoli.identifier("glowing"), new SerializableData(), (data, entity) -> Minecraft.m_91087_().m_91314_(entity)));
    }

    private static void register(ConditionFactory<Entity> conditionFactory) {
        Registry.m_122965_(ApoliRegistries.ENTITY_CONDITION, (ResourceLocation)conditionFactory.getSerializerId(), conditionFactory);
    }
}

