/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.NamespaceAlias;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class ConditionType<T> {
    private final String conditionTypeName;
    private final Registry<ConditionFactory<T>> conditionRegistry;

    public ConditionType(String conditionTypeName, Registry<ConditionFactory<T>> conditionRegistry) {
        this.conditionTypeName = conditionTypeName;
        this.conditionRegistry = conditionRegistry;
    }

    public void write(FriendlyByteBuf buf, ConditionFactory.Instance conditionInstance) {
        conditionInstance.write(buf);
    }

    public ConditionFactory.Instance read(FriendlyByteBuf buf) {
        ResourceLocation type = ResourceLocation.m_135820_((String)buf.m_130136_(Short.MAX_VALUE));
        ConditionFactory conditionFactory = (ConditionFactory)this.conditionRegistry.m_7745_(type);
        return conditionFactory.read(buf);
    }

    public ConditionFactory.Instance read(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject obj = jsonElement.getAsJsonObject();
            if (!obj.has("type")) {
                throw new JsonSyntaxException(this.conditionTypeName + " json requires \"type\" identifier.");
            }
            String typeIdentifier = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
            ResourceLocation type = ResourceLocation.m_135820_((String)typeIdentifier);
            Optional optionalCondition = this.conditionRegistry.m_6612_(type);
            if (!optionalCondition.isPresent()) {
                if (NamespaceAlias.hasAlias(type)) {
                    optionalCondition = this.conditionRegistry.m_6612_(NamespaceAlias.resolveAlias(type));
                }
                if (!optionalCondition.isPresent()) {
                    throw new JsonSyntaxException(this.conditionTypeName + " json type \"" + type.toString() + "\" is not defined.");
                }
            }
            return ((ConditionFactory)optionalCondition.get()).read(obj);
        }
        throw new JsonSyntaxException(this.conditionTypeName + " has to be a JsonObject!");
    }
}

